//
// C++ Implementation: crossrefdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "crossrefdlg.h"
#include <klocale.h>
#include <klineedit.h>

#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qlabel.h>

CrossRefDlg::CrossRefDlg(QWidget *parent, const char *name)
 : KDialogBase( parent, name , true, "Crossref Authentication Required", KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
	QWidget* mainWidget = new QWidget(this, "Crossref");
	setMainWidget(mainWidget);
	QVBoxLayout* l = new QVBoxLayout(mainWidget, 0, KDialog::spacingHint());
	QLabel *lb1 = new QLabel(i18n("Crossref.org OpenURL interface requires user registration.%1Free Crossref.org acount can be obtained from www.crossref.org/requestaccount.").arg("\n") , mainWidget) ;
	l->addWidget(lb1);
	l->addWidget(new QWidget(mainWidget));
	QHBox* usernameBox = new QHBox ( mainWidget, "userNameBox" );
	usernameBox->setSpacing ( KDialog::spacingHint() );
	l->addWidget(usernameBox);
	
	QLabel* usernameLab = new QLabel ( i18n ( "User name:" ), usernameBox );
	userEdit = new KLineEdit ( usernameBox );
	usernameLab->setBuddy ( userEdit );
	
	QWhatsThis::add ( userEdit, i18n ( "Enter crossref.org user name into this box." ) );
	usernameBox->setStretchFactor(usernameLab, 1);
	usernameBox->setStretchFactor(userEdit, 1);
	
	
	QHBox* passwordBox = new QHBox ( mainWidget, "passwordBox" );
	passwordBox->setSpacing ( KDialog::spacingHint() );
	l->addWidget(passwordBox);
	
	QLabel* passwordLab = new QLabel ( i18n ( "Password:" ), passwordBox );
	passwordEdit = new KLineEdit ( passwordBox );
	passwordEdit->setEchoMode(QLineEdit::Password);
	passwordLab->setBuddy ( passwordEdit );
	
	QWhatsThis::add ( passwordEdit, i18n ( "Enter crossref.org password into this box." ) );

	passwordBox->setStretchFactor(passwordLab, 1);
	passwordBox->setStretchFactor(passwordEdit, 1);
	
	saveAccount = new QCheckBox ( i18n ( "Save user name and password" ), mainWidget );
	l->addWidget(saveAccount);
	QWhatsThis::add ( saveAccount, i18n ( "Check this box to have your Crossref.org user name and password saved into KBib configuration file." ) );
	// stretch to fill lower area
	l->addStretch ( 1 );
}


CrossRefDlg::~CrossRefDlg()
{
}

QString CrossRefDlg::getUser(){
	return userEdit->text();	
}

QString CrossRefDlg::getPassword(){
	return passwordEdit->text();
}

bool CrossRefDlg::isSaveAccount(){
	return saveAccount->isChecked();	
	
}

#include "crossrefdlg.moc"
