/*
 * Copyright (C) 2008 Daniel Žalar (danizmax@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * TrackInfoWindow.java
 *
 * Created on May 10, 2008, 12:42 PM
 */

package org.danizmax.jsymphonic.gui.TrackInfo;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.naurd.media.jsymphonic.title.Title;

/**
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class TrackInfoWindow extends javax.swing.JFrame {

     private static Logger logger = Logger.getLogger("org.danizmax.jsymphonic.gui.TrackInfo.TrackInfoWindow");
     private NumberFormat nf = NumberFormat.getInstance();
    
   /**
    * Creates new form TrackInfoWindow  
    * @param trackobject the track object that represents the file
    */
    public TrackInfoWindow(Title trackobject) {
        initComponents();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(10);
        fillFields(trackobject);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        summaryPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        summaryLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        lenghtLabel = new javax.swing.JLabel();
        bitrateLabel = new javax.swing.JLabel();
        samplerateLabel = new javax.swing.JLabel();
        samplerateTextLabel = new javax.swing.JLabel();
        bitrateTextLabel = new javax.swing.JLabel();
        lenghtTextLabel = new javax.swing.JLabel();
        sizeLabel = new javax.swing.JLabel();
        sizeTextLabel = new javax.swing.JLabel();
        formatTextLabel = new javax.swing.JLabel();
        formatLabel = new javax.swing.JLabel();
        locationLabel = new javax.swing.JLabel();
        locationTextLabel = new javax.swing.JLabel();
        id3Panel = new javax.swing.JPanel();
        artistLabel1 = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();
        albumLabel = new javax.swing.JLabel();
        yearLabel = new javax.swing.JLabel();
        trackLabel = new javax.swing.JLabel();
        diskLabel = new javax.swing.JLabel();
        composerLabel = new javax.swing.JLabel();
        genreLabel = new javax.swing.JLabel();
        commnetLabel = new javax.swing.JLabel();
        artistTextField = new javax.swing.JTextField();
        titleTextField = new javax.swing.JTextField();
        albumTextField = new javax.swing.JTextField();
        yearTextField = new javax.swing.JTextField();
        trackTextField = new javax.swing.JTextField();
        diskTextField = new javax.swing.JTextField();
        composerTextField = new javax.swing.JTextField();
        genreTextField = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        commentTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setName("Form"); // NOI18N
        setResizable(false);

        okButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/ok.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/language"); // NOI18N
        okButton.setText(bundle.getString("global.OK")); // NOI18N
        okButton.setName("okButton"); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/cancel.png"))); // NOI18N
        cancelButton.setText(bundle.getString("global.Cancel")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jTabbedPane1.setMinimumSize(new java.awt.Dimension(650, 310));
        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        summaryPanel.setName("summaryPanel"); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setName("jPanel1"); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        summaryLabel.setName("summaryLabel"); // NOI18N

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel2.setName("jPanel2"); // NOI18N

        lenghtLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        lenghtLabel.setText(bundle.getString("TrackInfoWindow.lenghtLabel.text")); // NOI18N
        lenghtLabel.setName("lenghtLabel"); // NOI18N

        bitrateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        bitrateLabel.setText(bundle.getString("TrackInfoWindow.bitrateLabel.text")); // NOI18N
        bitrateLabel.setName("bitrateLabel"); // NOI18N

        samplerateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        samplerateLabel.setText(bundle.getString("TrackInfoWindow.samplerateLabel.text")); // NOI18N
        samplerateLabel.setName("samplerateLabel"); // NOI18N

        samplerateTextLabel.setName("samplerateTextLabel"); // NOI18N

        bitrateTextLabel.setName("bitrateTextLabel"); // NOI18N

        lenghtTextLabel.setName("lenghtTextLabel"); // NOI18N

        sizeLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        sizeLabel.setText(bundle.getString("TrackInfoWindow.sizeLabel.text")); // NOI18N
        sizeLabel.setName("sizeLabel"); // NOI18N

        sizeTextLabel.setName("sizeTextLabel"); // NOI18N

        formatTextLabel.setName("formatTextLabel"); // NOI18N

        formatLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        formatLabel.setText(bundle.getString("TrackInfoWindow.formatLabel.text")); // NOI18N
        formatLabel.setName("formatLabel"); // NOI18N

        locationLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        locationLabel.setText(bundle.getString("TrackInfoWindow.locationLabel.text")); // NOI18N
        locationLabel.setName("locationLabel"); // NOI18N

        locationTextLabel.setName("locationTextLabel"); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(locationLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 113, Short.MAX_VALUE)
                    .addComponent(formatLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 113, Short.MAX_VALUE)
                    .addComponent(sizeLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 113, Short.MAX_VALUE)
                    .addComponent(samplerateLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 113, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(bitrateLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(lenghtLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 113, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(bitrateTextLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE)
                    .addComponent(lenghtTextLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE)
                    .addComponent(samplerateTextLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE)
                    .addComponent(sizeTextLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE)
                    .addComponent(formatTextLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE)
                    .addComponent(locationTextLabel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 474, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(lenghtTextLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(lenghtLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(bitrateTextLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bitrateLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(samplerateTextLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(samplerateLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(sizeTextLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(sizeLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(formatLabel)
                    .addComponent(formatTextLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(locationLabel)
                    .addComponent(locationTextLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        javax.swing.GroupLayout summaryPanelLayout = new javax.swing.GroupLayout(summaryPanel);
        summaryPanel.setLayout(summaryPanelLayout);
        summaryPanelLayout.setHorizontalGroup(
            summaryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(summaryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(summaryPanelLayout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(summaryLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 507, Short.MAX_VALUE)))
                .addContainerGap())
        );
        summaryPanelLayout.setVerticalGroup(
            summaryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(summaryPanelLayout.createSequentialGroup()
                .addGroup(summaryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(summaryPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(summaryPanelLayout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addComponent(summaryLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle.getString("TrackInfoWindow.summaryPanel.TabConstraints.tabTitle"), summaryPanel); // NOI18N

        id3Panel.setName("id3Panel"); // NOI18N

        artistLabel1.setText(bundle.getString("TrackInfoWindow.artistLabel1.text")); // NOI18N
        artistLabel1.setName("artistLabel1"); // NOI18N

        titleLabel.setText(bundle.getString("TrackInfoWindow.titleLabel.text")); // NOI18N
        titleLabel.setName("titleLabel"); // NOI18N

        albumLabel.setText(bundle.getString("TrackInfoWindow.albumLabel.text")); // NOI18N
        albumLabel.setName("albumLabel"); // NOI18N

        yearLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        yearLabel.setText(bundle.getString("TrackInfoWindow.yearLabel.text")); // NOI18N
        yearLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        yearLabel.setName("yearLabel"); // NOI18N

        trackLabel.setText(bundle.getString("TrackInfoWindow.trackLabel.text")); // NOI18N
        trackLabel.setName("trackLabel"); // NOI18N

        diskLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        diskLabel.setText(bundle.getString("TrackInfoWindow.diskLabel.text")); // NOI18N
        diskLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        diskLabel.setName("diskLabel"); // NOI18N

        composerLabel.setText(bundle.getString("TrackInfoWindow.composerLabel.text")); // NOI18N
        composerLabel.setName("composerLabel"); // NOI18N

        genreLabel.setText(bundle.getString("TrackInfoWindow.genreLabel.text")); // NOI18N
        genreLabel.setName("genreLabel"); // NOI18N

        commnetLabel.setText(bundle.getString("TrackInfoWindow.commnetLabel.text")); // NOI18N
        commnetLabel.setName("commnetLabel"); // NOI18N

        artistTextField.setName("artistTextField"); // NOI18N

        titleTextField.setName("titleTextField"); // NOI18N

        albumTextField.setName("albumTextField"); // NOI18N

        yearTextField.setMaximumSize(new java.awt.Dimension(2147483647, 80));
        yearTextField.setMinimumSize(new java.awt.Dimension(4, 80));
        yearTextField.setName("yearTextField"); // NOI18N

        trackTextField.setName("trackTextField"); // NOI18N

        diskTextField.setName("diskTextField"); // NOI18N

        composerTextField.setName("composerTextField"); // NOI18N

        genreTextField.setName("genreTextField"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        commentTextArea.setColumns(20);
        commentTextArea.setRows(5);
        commentTextArea.setName("commentTextArea"); // NOI18N
        jScrollPane1.setViewportView(commentTextArea);

        javax.swing.GroupLayout id3PanelLayout = new javax.swing.GroupLayout(id3Panel);
        id3Panel.setLayout(id3PanelLayout);
        id3PanelLayout.setHorizontalGroup(
            id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(commnetLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(trackLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(genreLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(artistLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE)
                    .addComponent(albumLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(titleLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(composerLabel))
                .addGap(23, 23, 23)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE)
                    .addComponent(genreTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE)
                    .addComponent(albumTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE)
                    .addComponent(titleTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE)
                    .addComponent(artistTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, id3PanelLayout.createSequentialGroup()
                        .addComponent(trackTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(diskLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(diskTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(yearLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 111, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(yearTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 64, Short.MAX_VALUE))
                    .addComponent(composerTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 493, Short.MAX_VALUE))
                .addContainerGap())
        );
        id3PanelLayout.setVerticalGroup(
            id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(artistLabel1)
                    .addComponent(artistTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(titleLabel)
                    .addComponent(titleTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(albumLabel)
                    .addComponent(albumTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(genreLabel)
                    .addComponent(genreTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(trackLabel)
                    .addComponent(trackTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(diskLabel)
                    .addComponent(diskTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(yearLabel)
                    .addComponent(yearTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(composerLabel)
                    .addComponent(composerTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(id3PanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(commnetLabel)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 34, Short.MAX_VALUE))
                .addContainerGap())
        );

        jTabbedPane1.addTab(bundle.getString("TrackInfoWindow.id3Panel.TabConstraints.tabTitle"), id3Panel); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 650, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(okButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelButton)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 311, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void fillFields(Title trackObject){
        artistTextField.setText(trackObject.getArtist());
        titleTextField.setText(trackObject.getTitle());
        albumTextField.setText(trackObject.getAlbum());
        genreTextField.setText(trackObject.getGenre());
        trackTextField.setText(String.valueOf(trackObject.getTitleNumber()));
        //diskTextField.setText(trackObject.get);
        yearTextField.setText(String.valueOf(trackObject.getYear()));
        //composerTextField.setText(trackObject.get);
        //commentTextArea.setTabSize(trackObject.get);
        
        summaryLabel.setText(trackObject.getTitle() + " " + java.util.ResourceBundle.getBundle("localization/language").getString("TrackInfoWindow.by") +" "+ trackObject.getArtist() +" "+ java.util.ResourceBundle.getBundle("localization/language").getString("TrackInfoWindow.on") +" " + trackObject.getAlbum());
        this.setTitle(summaryLabel.getText());
        
        lenghtTextLabel.setText(longToTime(trackObject.getLength())); //TODO the method getLength() seems to be  giving wrong information!
        bitrateTextLabel.setText(String.valueOf(trackObject.getBitRate()) + " " + "kbps");
        samplerateTextLabel.setText(String.valueOf(trackObject.getFrequency()) + " " + "kHz");
        sizeTextLabel.setText(String.valueOf(trackObject.size()/1024) + " " + "kB");
        try {
            //formatTextLabel.setText(trackObject.); //TODO request a method in Title class to return format type in string!
            locationTextLabel.setText(trackObject.getSourceFile().getCanonicalPath());
        } catch (IOException ex) {
            Logger.getLogger(TrackInfoWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    /** convert milliseconds to d+ HH:MM:SS
     * @param t time
     * @return returns date in the form d+ HH:MM:SS
     */
    private String longToTime(long t){
        int hours=0, minutes = 0, seconds =0, days =0;
        String out ="";
        while(t>=3600000){
            hours++;
            t -=3600000;
        }

        while(hours>=24){
            days++;
            hours-=24;
        }

        while(t>=60000){
            minutes++;
            t -=60000;
        }

        seconds=(int)t/1000;
        if(days>0){
            out = days+ " dni, " + nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }else{
            out = nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }

        return  out;
    }
    
private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
this.dispose();
}//GEN-LAST:event_okButtonActionPerformed

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel albumLabel;
    private javax.swing.JTextField albumTextField;
    private javax.swing.JLabel artistLabel1;
    private javax.swing.JTextField artistTextField;
    private javax.swing.JLabel bitrateLabel;
    private javax.swing.JLabel bitrateTextLabel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextArea commentTextArea;
    private javax.swing.JLabel commnetLabel;
    private javax.swing.JLabel composerLabel;
    private javax.swing.JTextField composerTextField;
    private javax.swing.JLabel diskLabel;
    private javax.swing.JTextField diskTextField;
    private javax.swing.JLabel formatLabel;
    private javax.swing.JLabel formatTextLabel;
    private javax.swing.JLabel genreLabel;
    private javax.swing.JTextField genreTextField;
    private javax.swing.JPanel id3Panel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel lenghtLabel;
    private javax.swing.JLabel lenghtTextLabel;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JLabel locationTextLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel samplerateLabel;
    private javax.swing.JLabel samplerateTextLabel;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JLabel sizeTextLabel;
    private javax.swing.JLabel summaryLabel;
    private javax.swing.JPanel summaryPanel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JTextField titleTextField;
    private javax.swing.JLabel trackLabel;
    private javax.swing.JTextField trackTextField;
    private javax.swing.JLabel yearLabel;
    private javax.swing.JTextField yearTextField;
    // End of variables declaration//GEN-END:variables

    
    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger aLogger) {
        logger = aLogger;
    }
    
    public static void setParentLogger(Logger aLogger) {
        logger.setParent(aLogger);
    }
}
