/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.TableColumn;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class ForeachTagHandler
extends AbstractTagHandler {
    public ForeachTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        String type = this.getString("type");
        String id = this.getString("id");
        String refid = this.getString("refid");
        Object obj = this.getXMLTestCase().getProperty(refid);
        this.getTestCase();
        TestCase.assertNotNull((String)"for-each refid is null", (Object)obj);
        boolean debug = this.getXMLTestCase().getDebug();
        if ("listitem".equals(type)) {
            ListModel model = null;
            if (obj instanceof JList) {
                JList list = (JList)obj;
                model = list.getModel();
            } else if (obj instanceof JComboBox) {
                model = ((JComboBox)obj).getModel();
            }
            this.getTestCase();
            TestCase.assertNotNull((String)("could not get model from:" + obj.getClass().getName()), model);
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object value = model.getElementAt(i);
                if (debug) {
                    System.err.println("for-each: listitem for index(" + i + ") " + value);
                }
                this.getXMLTestCase().addProperty(id, value);
                this.getXMLTestCase().addProperty(id + "." + "index", new Integer(i));
                this.getXMLTestCase().processChildren(this.getElement());
            }
        } else if ("tab".equals(type)) {
            this.getTestCase();
            TestCase.assertTrue((String)(refid + " not instance of JTabbedPane"), (boolean)(obj instanceof JTabbedPane));
            JTabbedPane tab = (JTabbedPane)obj;
            int columns = tab.getTabCount();
            String columnid = id + "." + "index";
            for (int c = 0; c < columns; ++c) {
                String title = tab.getTitleAt(c);
                this.getXMLTestCase().addProperty(id, title);
                this.getXMLTestCase().addProperty(columnid, new Integer(c));
                this.getXMLTestCase().processChildren(this.getElement());
            }
        } else if ("tablecolumn".equals(type)) {
            this.getTestCase();
            TestCase.assertTrue((String)(refid + " not instance of JTable"), (boolean)(obj instanceof JTable));
            JTable table = (JTable)obj;
            int columns = table.getColumnCount();
            String columnid = id + "." + "column";
            for (int c = 0; c < columns; ++c) {
                TableColumn tc = table.getColumnModel().getColumn(c);
                Object o = tc.getHeaderValue();
                if (o == null) {
                    o = tc.getIdentifier();
                }
                this.getXMLTestCase().addProperty(id, o);
                this.getXMLTestCase().addProperty(columnid, new Integer(c));
                this.getXMLTestCase().processChildren(this.getElement());
            }
        } else if ("tablecell".equals(type)) {
            this.getTestCase();
            TestCase.assertTrue((String)(refid + " not instance of JTable"), (boolean)(obj instanceof JTable));
            JTable table = (JTable)obj;
            int rows = table.getRowCount();
            int columns = table.getColumnCount();
            String rowid = id + "." + "row";
            String columnid = id + "." + "column";
            int row = this.getInt("row", -1);
            int column = this.getInt("column", -1);
            if (row == -1 && column == -1) {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        Object cell = table.getValueAt(r, c);
                        if (debug) {
                            System.err.println("Foreach: tablecell(" + r + "," + c + ") " + cell);
                        }
                        this.getXMLTestCase().addProperty(id, cell);
                        this.getXMLTestCase().addProperty(rowid, new Integer(r));
                        this.getXMLTestCase().addProperty(columnid, new Integer(c));
                        this.getXMLTestCase().processChildren(this.getElement());
                    }
                }
            } else if (row == -1) {
                for (int r = 0; r < rows; ++r) {
                    Object cell = table.getValueAt(r, column);
                    if (debug) {
                        System.err.println("Foreach: tablecell(" + r + "," + column + ") " + cell);
                    }
                    this.getXMLTestCase().addProperty(id, cell);
                    this.getXMLTestCase().addProperty(rowid, new Integer(r));
                    this.getXMLTestCase().addProperty(columnid, new Integer(column));
                    this.getXMLTestCase().processChildren(this.getElement());
                }
            } else if (column == -1) {
                for (int c = 0; c < columns; ++c) {
                    Object cell = table.getValueAt(row, c);
                    if (debug) {
                        System.err.println("Foreach: tablecell(" + row + "," + c + ") " + cell);
                    }
                    this.getXMLTestCase().addProperty(id, cell);
                    this.getXMLTestCase().addProperty(rowid, new Integer(row));
                    this.getXMLTestCase().addProperty(columnid, new Integer(c));
                    this.getXMLTestCase().processChildren(this.getElement());
                }
            } else {
                Object cell = table.getValueAt(row, column);
                if (debug) {
                    System.err.println("Foreach: tablecell(" + row + "," + column + ") " + cell);
                }
                this.getXMLTestCase().addProperty(id, cell);
                this.getXMLTestCase().addProperty(rowid, new Integer(row));
                this.getXMLTestCase().addProperty(columnid, new Integer(column));
                this.getXMLTestCase().processChildren(this.getElement());
            }
        }
    }

    public void validateElement() throws XMLException {
        super.checkElementTagName("foreach");
        super.checkRequiredAttribute("type");
        super.checkRequiredAttribute("id");
        super.checkRequiredAttribute("refid");
    }
}

