/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JViewport;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.MouseEventData;

public class MouseWheelEventData
extends MouseEventData {
    public static final int DEFAULT_MOUSE_CLICKS = 0;
    private static int s_mouseWheelEvent;
    private static Class s_mweClass;
    private static Method s_getWheelRotationMethod;
    private static Method s_getScrollAmountMethod;
    private Component m_comp;
    private int m_scrollAmount = 0;
    private int m_wheelRotation = 0;

    public MouseWheelEventData() {
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp) {
        this(testCase, comp, 3, 1);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int wheelRotation) {
        this(testCase, comp, 3, wheelRotation, 0);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation) {
        this(testCase, comp, amount, wheelRotation, 0);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, 16);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, modifiers, false);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, MouseWheelEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, long sleepTime) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, 16, false, sleepTime);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers, boolean isPopupTrigger) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, modifiers, isPopupTrigger, 300L);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, MouseWheelEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, comp, amount, wheelRotation, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public MouseWheelEventData(JFCTestCase testCase, Component comp, int amount, int wheelRotation, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setScrollAmount(amount);
        this.setWheelRotation(wheelRotation);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setSource(Component comp) {
        this.m_comp = comp;
    }

    public final Component getSource() {
        return this.m_comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public final void setScrollAmount(int scrollAmount) {
        this.m_scrollAmount = scrollAmount;
    }

    public final int getScrollAmount() {
        return this.m_scrollAmount;
    }

    public final void setWheelRotation(int wheelRotation) {
        this.m_wheelRotation = wheelRotation;
    }

    public final int getWheelRotation() {
        return this.m_wheelRotation;
    }

    public boolean canConsume(AWTEvent ae) {
        if (s_mouseWheelEvent == 0 || ae.getID() != s_mouseWheelEvent) {
            return false;
        }
        if (this.isValid()) {
            int modifiers = ((MouseEvent)ae).getModifiers();
            if (ae.getSource() != this.getSource()) {
                return false;
            }
            if (modifiers != this.getModifiers()) {
                return false;
            }
            try {
                int wheelRotation = (Integer)s_getWheelRotationMethod.invoke((Object)ae, new Object[0]);
                if (wheelRotation * this.getWheelRotation() < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean consume(AWTEvent ae) {
        MouseEvent me = (MouseEvent)ae;
        try {
            int amount = (Integer)s_getScrollAmountMethod.invoke((Object)ae, new Object[0]);
            this.setScrollAmount(amount);
            int wheelRotation = (Integer)s_getWheelRotationMethod.invoke((Object)ae, new Object[0]);
            this.setWheelRotation(wheelRotation + this.getWheelRotation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isValid()) {
            return true;
        }
        Component source = (Component)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        this.setSleepTime(this.getDefaultSleepTime());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MouseWheelEventData data = (MouseWheelEventData)o;
        return data.getWheelRotation() == this.getWheelRotation() && data.getScrollAmount() == this.getScrollAmount();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        Container parent = null;
        parent = this.getSource() instanceof Container ? (Container)this.getSource() : this.getSource().getParent();
        while (parent.getParent() != null && !(parent instanceof JViewport)) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JViewport)) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.awtSleep(this.getSleepTime());
        }
        Rectangle bounds = parent.getBounds();
        Point location = parent.getLocationOnScreen();
        bounds.x += location.x;
        bounds.y += location.y;
        this.setLocationOnScreen(this.calculatePoint(bounds));
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" amount:" + this.getScrollAmount());
        buf.append(" rotation:" + this.getWheelRotation());
        return buf.toString();
    }

    static {
        try {
            s_mweClass = Class.forName("java.awt.event.MouseWheelEvent");
            s_mouseWheelEvent = s_mweClass.getField("MOUSE_WHEEL").getInt(null);
            s_getWheelRotationMethod = s_mweClass.getMethod("getWheelRotation", new Class[0]);
            s_getScrollAmountMethod = s_mweClass.getMethod("getScrollAmount", new Class[0]);
        }
        catch (Exception e) {
            s_mouseWheelEvent = 0;
        }
    }
}

