/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.lock;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.exception.ScreenLockException;
import org.fest.util.Strings;

@ThreadSafe
public final class ScreenLock {
    @GuardedBy(value="this")
    private boolean locked;
    @GuardedBy(value="this")
    private Object owner;

    synchronized Object owner() {
        return this.owner;
    }

    public synchronized void acquire(Object newOwner) {
        while (this.locked) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                break;
            }
            this.acquire(newOwner);
            this.notifyAll();
        }
        this.locked = true;
        this.owner = newOwner;
    }

    public synchronized boolean acquiredBy(Object possibleOwner) {
        if (!this.locked) {
            return false;
        }
        return this.owner == possibleOwner;
    }

    public synchronized void release(Object currentOwner) {
        if (!this.locked) {
            throw new ScreenLockException("No lock to release");
        }
        if (this.owner != currentOwner) {
            throw new ScreenLockException(Strings.concat((Object[])new Object[]{currentOwner, " is not the lock owner"}));
        }
        this.locked = false;
        this.owner = null;
    }

    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

