/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import java.applet.Applet;
import java.util.HashMap;
import java.util.Map;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.launcher.AppletParameter;
import org.fest.swing.launcher.NewAppletViewerQuery;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletLauncher {
    private final Applet applet;
    private final Map<String, String> parameters = new HashMap<String, String>();

    @RunsInEDT
    public static AppletLauncher applet(String appletType) {
        if (appletType == null) {
            throw new NullPointerException("The name of the applet type should not be null");
        }
        if (Strings.isEmpty((String)appletType)) {
            throw new IllegalArgumentException("The name of the applet type should not be empty");
        }
        Object o = AppletLauncher.load(appletType);
        if (!(o instanceof Applet)) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"The given type is not a subclass of ", Applet.class.getName()}));
        }
        return AppletLauncher.applet((Applet)o);
    }

    @RunsInEDT
    private static Object load(String typeName) {
        try {
            Class<?> type = Class.forName(typeName);
            return AppletLauncher.loadInEDT(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(Strings.concat((Object[])new Object[]{"Unable to load class ", typeName}), e);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotInstantiateApplet(typeName, e);
        }
    }

    @RunsInEDT
    public static AppletLauncher applet(Class<? extends Applet> appletType) {
        if (appletType == null) {
            throw new NullPointerException("The applet type should not be null");
        }
        try {
            Object loadInEDT = AppletLauncher.loadInEDT(appletType);
            return AppletLauncher.applet((Applet)loadInEDT);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotInstantiateApplet(appletType.getName(), e);
        }
    }

    @RunsInEDT
    private static Object loadInEDT(final Class<?> type) {
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            protected Object executeInEDT() throws Exception {
                return type.newInstance();
            }
        });
    }

    private static UnexpectedException cannotInstantiateApplet(String appletType, Exception cause) {
        throw new UnexpectedException(Strings.concat((Object[])new Object[]{"Unable to create a new instance of ", appletType}), cause);
    }

    public static AppletLauncher applet(Applet applet) {
        return new AppletLauncher(applet);
    }

    private AppletLauncher(Applet applet) {
        if (applet == null) {
            throw new NullPointerException("The applet to launch should not be null");
        }
        this.applet = applet;
    }

    public AppletLauncher withParameters(Map<String, String> newParameters) {
        if (newParameters == null) {
            throw new NullPointerException("The map of parameters should not be null");
        }
        this.parameters.clear();
        this.parameters.putAll(newParameters);
        return this;
    }

    public AppletLauncher withParameters(AppletParameter ... newParameters) {
        if (newParameters == null) {
            throw new NullPointerException("The array of parameters should not be null");
        }
        this.parameters.clear();
        for (AppletParameter parameter : newParameters) {
            this.add(parameter);
        }
        return this;
    }

    private void add(AppletParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("Found a null parameter");
        }
        this.parameters.put(parameter.name, parameter.value);
    }

    public AppletViewer start() {
        return NewAppletViewerQuery.showAppletViewerWith(this.applet, this.parameters);
    }
}

