/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JTableHeaderDriver;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableHeaderFixture
extends ComponentFixture<JTableHeader> {
    private JTableHeaderDriver driver;

    public JTableHeaderFixture(Robot robot, JTableHeader target) {
        super(robot, target);
        this.updateDriver(new JTableHeaderDriver(robot));
    }

    final void updateDriver(JTableHeaderDriver newDriver) {
        this.driver = newDriver;
    }

    public JTableHeaderFixture clickColumn(int index) {
        this.driver.clickColumn((JTableHeader)this.target, index);
        return this;
    }

    public JPopupMenuFixture showPopupMenuAt(int columnIndex) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTableHeader)this.target, columnIndex);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JPopupMenuFixture showPopupMenuAt(String columnName) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTableHeader)this.target, columnName);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JTableHeaderFixture clickColumn(int index, MouseClickInfo mouseClickInfo) {
        this.driver.clickColumn((JTableHeader)this.target, index, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }

    public JTableHeaderFixture clickColumn(String columnName) {
        this.driver.clickColumn((JTableHeader)this.target, columnName);
        return this;
    }

    public JTableHeaderFixture clickColumn(String columnName, MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
        this.driver.clickColumn((JTableHeader)this.target, columnName, mouseClickInfo.button(), mouseClickInfo.times());
        return this;
    }
}

