/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JSlider;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JSliderDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSliderFixture
extends JPopupMenuInvokerFixture<JSlider>
implements CommonComponentFixture {
    private JSliderDriver driver;

    public JSliderFixture(Robot robot, JSlider target) {
        super(robot, target);
        this.createDriver();
    }

    public JSliderFixture(Robot robot, String sliderName) {
        super(robot, sliderName, JSlider.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JSliderDriver(this.robot));
    }

    final void updateDriver(JSliderDriver newDriver) {
        this.driver = newDriver;
    }

    public JSliderFixture slideTo(int value) {
        this.driver.slide((JSlider)this.target, value);
        return this;
    }

    public JSliderFixture slideToMaximum() {
        this.driver.slideToMaximum((JSlider)this.target);
        return this;
    }

    public JSliderFixture slideToMinimum() {
        this.driver.slideToMinimum((JSlider)this.target);
        return this;
    }

    @Override
    public JSliderFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JSliderFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JSliderFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JSliderFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JSliderFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JSliderFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JSliderFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JSliderFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JSliderFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JSliderFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JSliderFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JSliderFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JSliderFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JSliderFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JSliderFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JSliderFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }
}

