/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JOptionPane;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JOptionPaneDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.ComponentFixtureValidator;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOptionPaneFixture
extends ComponentFixture<JOptionPane>
implements CommonComponentFixture {
    private JOptionPaneDriver driver;

    public JOptionPaneFixture(Robot robot) {
        this(robot, JOptionPaneFixture.findShowingOptionPane(robot));
    }

    private static JOptionPane findShowingOptionPane(Robot robot) {
        ComponentFixtureValidator.notNullRobot(robot);
        return robot.finder().findByType(JOptionPane.class, true);
    }

    public JOptionPaneFixture(Robot robot, JOptionPane target) {
        super(robot, target);
        this.updateDriver(new JOptionPaneDriver(robot));
    }

    final void updateDriver(JOptionPaneDriver newDriver) {
        this.driver = newDriver;
    }

    public JButtonFixture okButton() {
        return new JButtonFixture(this.robot, this.driver.okButton((JOptionPane)this.target));
    }

    public JButtonFixture cancelButton() {
        return new JButtonFixture(this.robot, this.driver.cancelButton((JOptionPane)this.target));
    }

    public JButtonFixture yesButton() {
        return new JButtonFixture(this.robot, this.driver.yesButton((JOptionPane)this.target));
    }

    public JButtonFixture noButton() {
        return new JButtonFixture(this.robot, this.driver.noButton((JOptionPane)this.target));
    }

    public JButtonFixture buttonWithText(String text) {
        return new JButtonFixture(this.robot, this.driver.buttonWithText((JOptionPane)this.target, text));
    }

    public JButtonFixture button() {
        return new JButtonFixture(this.robot, this.driver.button((JOptionPane)this.target));
    }

    public JTextComponentFixture textBox() {
        return new JTextComponentFixture(this.robot, this.driver.textBox((JOptionPane)this.target));
    }

    @Override
    public JOptionPaneFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JOptionPaneFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JOptionPaneFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    public JOptionPaneFixture requireErrorMessage() {
        this.driver.requireErrorMessage((JOptionPane)this.target);
        return this;
    }

    public JOptionPaneFixture requireInformationMessage() {
        this.driver.requireInformationMessage((JOptionPane)this.target);
        return this;
    }

    public JOptionPaneFixture requireWarningMessage() {
        this.driver.requireWarningMessage((JOptionPane)this.target);
        return this;
    }

    public JOptionPaneFixture requireQuestionMessage() {
        this.driver.requireQuestionMessage((JOptionPane)this.target);
        return this;
    }

    public JOptionPaneFixture requirePlainMessage() {
        this.driver.requirePlainMessage((JOptionPane)this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JOptionPaneFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JOptionPaneFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JOptionPaneFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    public JOptionPaneFixture requireTitle(String title) {
        this.driver.requireTitle((JOptionPane)this.target, title);
        return this;
    }

    public JOptionPaneFixture requireMessage(Object message) {
        this.driver.requireMessage((JOptionPane)this.target, message);
        return this;
    }

    public JOptionPaneFixture requireOptions(Object[] options) {
        this.driver.requireOptions((JOptionPane)this.target, options);
        return this;
    }

    @Override
    public JOptionPaneFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JOptionPaneFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JOptionPaneFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }
}

