/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JList;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ItemGroupFixture;
import org.fest.swing.fixture.JListItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JListFixture
extends JPopupMenuInvokerFixture<JList>
implements CommonComponentFixture,
ItemGroupFixture {
    private JListDriver driver;

    public JListFixture(Robot robot, String listName) {
        super(robot, listName, JList.class);
        this.createDriver();
    }

    public JListFixture(Robot robot, JList target) {
        super(robot, target);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JListDriver(this.robot));
    }

    final void updateDriver(JListDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public String valueAt(int index) {
        return this.driver.value((JList)this.target, index);
    }

    @Override
    public String[] contents() {
        return this.driver.contentsOf((JList)this.target);
    }

    public String[] selection() {
        return this.driver.selectionOf((JList)this.target);
    }

    public JListItemFixture item(int index) {
        return new JListItemFixture(this, index);
    }

    public JListItemFixture item(String text) {
        return new JListItemFixture(this, this.driver.indexOf((JList)this.target, text));
    }

    public JListFixture selectItems(Range.From from, Range.To to) {
        this.driver.selectItems((JList)this.target, from, to);
        return this;
    }

    public JListFixture selectItems(int ... indices) {
        this.driver.selectItems((JList)this.target, indices);
        return this;
    }

    @Override
    public JListFixture selectItem(int index) {
        this.driver.selectItem((JList)this.target, index);
        return this;
    }

    public JListFixture selectItems(String ... items) {
        this.driver.selectItems((JList)this.target, items);
        return this;
    }

    @Override
    public JListFixture selectItem(String text) {
        this.driver.selectItem((JList)this.target, text);
        return this;
    }

    public JListFixture doubleClickItem(int index) {
        this.clickItem(index, MouseButton.LEFT_BUTTON, 2);
        return this;
    }

    public JListFixture doubleClickItem(String text) {
        this.driver.clickItem((JList)this.target, text, MouseButton.LEFT_BUTTON, 2);
        return this;
    }

    void clickItem(int index, MouseButton button, int times) {
        this.driver.clickItem((JList)this.target, index, button, times);
    }

    @Override
    public JListFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JListFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JListFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JListFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JListFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JListFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JListFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JListFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JListFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JListFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    public JListFixture drag(String text) {
        this.driver.drag((JList)this.target, text);
        return this;
    }

    public JListFixture drop(String text) {
        this.driver.drop((JList)this.target, text);
        return this;
    }

    public JListFixture drop() {
        this.driver.drop((JList)this.target);
        return this;
    }

    public JListFixture drag(int index) {
        this.driver.drag((JList)this.target, index);
        return this;
    }

    public JListFixture drop(int index) {
        this.driver.drop((JList)this.target, index);
        return this;
    }

    public JPopupMenuFixture showPopupMenuAt(int index) {
        return new JPopupMenuFixture(this.robot, this.driver.showPopupMenu((JList)this.target, index));
    }

    public JPopupMenuFixture showPopupMenuAt(String text) {
        return new JPopupMenuFixture(this.robot, this.driver.showPopupMenu((JList)this.target, text));
    }

    @Override
    public JListFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JListFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JListFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JListFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JListFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JListFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JListFixture requireSelection(String text) {
        this.driver.requireSelection((JList)this.target, text);
        return this;
    }

    public JListFixture requireSelectedItems(String ... items) {
        this.driver.requireSelectedItems((JList)this.target, items);
        return this;
    }

    @Override
    public JListFixture requireNoSelection() {
        this.driver.requireNoSelection((JList)this.target);
        return this;
    }

    public JListFixture cellReader(JListCellReader cellReader) {
        this.driver.cellReader(cellReader);
        return this;
    }
}

