/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.FocusableComponentFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.TextDisplayFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JButtonFixture
extends JPopupMenuInvokerFixture<JButton>
implements CommonComponentFixture,
TextDisplayFixture {
    private AbstractButtonDriver driver;

    public JButtonFixture(Robot robot, JButton target) {
        super(robot, target);
        this.createDriver();
    }

    public JButtonFixture(Robot robot, String buttonName) {
        super(robot, buttonName, JButton.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new AbstractButtonDriver(this.robot));
    }

    final void updateDriver(AbstractButtonDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public String text() {
        return this.driver.textOf((AbstractButton)this.target);
    }

    @Override
    public JButtonFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JButtonFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JButtonFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JButtonFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JButtonFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JButtonFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JButtonFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JButtonFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JButtonFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JButtonFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public FocusableComponentFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JButtonFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JButtonFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JButtonFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JButtonFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JButtonFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JButtonFixture requireText(String expected) {
        this.driver.requireText((AbstractButton)this.target, expected);
        return this;
    }
}

