/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.fixture.ComponentContainerFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.ComponentFixtureExtension;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JFileChooserFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JMenuItemFinder;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JOptionPaneFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.JRadioButtonFixture;
import org.fest.swing.fixture.JScrollBarFixture;
import org.fest.swing.fixture.JScrollPaneFixture;
import org.fest.swing.fixture.JSliderFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JSplitPaneFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JToggleButtonFixture;
import org.fest.swing.fixture.JToolBarFixture;
import org.fest.swing.fixture.JTreeFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerFixture<T extends Container>
extends JPopupMenuInvokerFixture<T>
implements ComponentContainerFixture {
    private final JMenuItemFinder menuItemFinder;

    public ContainerFixture(Robot robot, Class<? extends T> type) {
        super(robot, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target);
    }

    public ContainerFixture(Robot robot, String name, Class<? extends T> type) {
        super(robot, name, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target);
    }

    public ContainerFixture(Robot robot, T target) {
        super(robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)target);
    }

    @Override
    public JButtonFixture button() {
        return new JButtonFixture(this.robot, this.findByType(JButton.class));
    }

    @Override
    public JButtonFixture button(GenericTypeMatcher<? extends JButton> matcher) {
        return new JButtonFixture(this.robot, this.find(matcher));
    }

    @Override
    public JButtonFixture button(String name) {
        return new JButtonFixture(this.robot, this.findByName(name, JButton.class));
    }

    @Override
    public JCheckBoxFixture checkBox() {
        return new JCheckBoxFixture(this.robot, this.findByType(JCheckBox.class));
    }

    @Override
    public JCheckBoxFixture checkBox(GenericTypeMatcher<? extends JCheckBox> matcher) {
        return new JCheckBoxFixture(this.robot, this.find(matcher));
    }

    @Override
    public JCheckBoxFixture checkBox(String name) {
        return new JCheckBoxFixture(this.robot, this.findByName(name, JCheckBox.class));
    }

    @Override
    public JComboBoxFixture comboBox() {
        return new JComboBoxFixture(this.robot, this.findByType(JComboBox.class));
    }

    @Override
    public JComboBoxFixture comboBox(GenericTypeMatcher<? extends JComboBox> matcher) {
        return new JComboBoxFixture(this.robot, this.find(matcher));
    }

    @Override
    public JComboBoxFixture comboBox(String name) {
        return new JComboBoxFixture(this.robot, this.findByName(name, JComboBox.class));
    }

    @Override
    public DialogFixture dialog() {
        return new DialogFixture(this.robot, this.findByType(Dialog.class));
    }

    @Override
    public DialogFixture dialog(GenericTypeMatcher<? extends Dialog> matcher) {
        return new DialogFixture(this.robot, this.find(matcher));
    }

    @Override
    public DialogFixture dialog(String name) {
        return new DialogFixture(this.robot, this.findByName(name, Dialog.class));
    }

    @Override
    public JFileChooserFixture fileChooser() {
        return new JFileChooserFixture(this.robot, this.findByType(JFileChooser.class));
    }

    @Override
    public JFileChooserFixture fileChooser(GenericTypeMatcher<? extends JFileChooser> matcher) {
        return new JFileChooserFixture(this.robot, this.find(matcher));
    }

    @Override
    public JFileChooserFixture fileChooser(String name) {
        return new JFileChooserFixture(this.robot, this.findByName(name, JFileChooser.class));
    }

    @Override
    public JLabelFixture label() {
        return new JLabelFixture(this.robot, this.findByType(JLabel.class));
    }

    @Override
    public JLabelFixture label(GenericTypeMatcher<? extends JLabel> matcher) {
        return new JLabelFixture(this.robot, this.find(matcher));
    }

    @Override
    public JLabelFixture label(String name) {
        return new JLabelFixture(this.robot, this.findByName(name, JLabel.class));
    }

    @Override
    public JListFixture list() {
        return new JListFixture(this.robot, this.findByType(JList.class));
    }

    @Override
    public JListFixture list(GenericTypeMatcher<? extends JList> matcher) {
        return new JListFixture(this.robot, this.find(matcher));
    }

    @Override
    public JListFixture list(String name) {
        return new JListFixture(this.robot, this.findByName(name, JList.class));
    }

    @Override
    public JMenuItemFixture menuItemWithPath(String ... path) {
        return new JMenuItemFixture(this.robot, this.menuItemFinder.menuItemWithPath(path));
    }

    @Override
    public JMenuItemFixture menuItem(String name) {
        boolean requireShowing = ComponentLookupScope.SHOWING_ONLY.equals((Object)this.robot.settings().componentLookupScope());
        return new JMenuItemFixture(this.robot, this.finder().findByName((Container)this.target, name, JMenuItem.class, requireShowing));
    }

    @Override
    public JMenuItemFixture menuItem(GenericTypeMatcher<? extends JMenuItem> matcher) {
        return new JMenuItemFixture(this.robot, this.find(matcher));
    }

    @Override
    public JOptionPaneFixture optionPane() {
        return new JOptionPaneFixture(this.robot);
    }

    @Override
    public JPanelFixture panel() {
        return new JPanelFixture(this.robot, this.findByType(JPanel.class));
    }

    @Override
    public JPanelFixture panel(GenericTypeMatcher<? extends JPanel> matcher) {
        return new JPanelFixture(this.robot, this.find(matcher));
    }

    @Override
    public JPanelFixture panel(String name) {
        return new JPanelFixture(this.robot, this.findByName(name, JPanel.class));
    }

    @Override
    public JRadioButtonFixture radioButton() {
        return new JRadioButtonFixture(this.robot, this.findByType(JRadioButton.class));
    }

    @Override
    public JRadioButtonFixture radioButton(GenericTypeMatcher<? extends JRadioButton> matcher) {
        return new JRadioButtonFixture(this.robot, this.find(matcher));
    }

    @Override
    public JRadioButtonFixture radioButton(String name) {
        return new JRadioButtonFixture(this.robot, this.findByName(name, JRadioButton.class));
    }

    @Override
    public JScrollBarFixture scrollBar() {
        return new JScrollBarFixture(this.robot, this.findByType(JScrollBar.class));
    }

    @Override
    public JScrollBarFixture scrollBar(GenericTypeMatcher<? extends JScrollBar> matcher) {
        return new JScrollBarFixture(this.robot, this.find(matcher));
    }

    @Override
    public JScrollBarFixture scrollBar(String name) {
        return new JScrollBarFixture(this.robot, this.findByName(name, JScrollBar.class));
    }

    @Override
    public JScrollPaneFixture scrollPane() {
        return new JScrollPaneFixture(this.robot, this.findByType(JScrollPane.class));
    }

    @Override
    public JScrollPaneFixture scrollPane(GenericTypeMatcher<? extends JScrollPane> matcher) {
        return new JScrollPaneFixture(this.robot, this.find(matcher));
    }

    @Override
    public JScrollPaneFixture scrollPane(String name) {
        return new JScrollPaneFixture(this.robot, this.findByName(name, JScrollPane.class));
    }

    @Override
    public JSliderFixture slider() {
        return new JSliderFixture(this.robot, this.findByType(JSlider.class));
    }

    @Override
    public JSliderFixture slider(GenericTypeMatcher<? extends JSlider> matcher) {
        return new JSliderFixture(this.robot, this.find(matcher));
    }

    @Override
    public JSliderFixture slider(String name) {
        return new JSliderFixture(this.robot, this.findByName(name, JSlider.class));
    }

    @Override
    public JSpinnerFixture spinner() {
        return new JSpinnerFixture(this.robot, this.findByType(JSpinner.class));
    }

    @Override
    public JSpinnerFixture spinner(GenericTypeMatcher<? extends JSpinner> matcher) {
        return new JSpinnerFixture(this.robot, this.find(matcher));
    }

    @Override
    public JSpinnerFixture spinner(String name) {
        return new JSpinnerFixture(this.robot, this.findByName(name, JSpinner.class));
    }

    @Override
    public JSplitPaneFixture splitPane() {
        return new JSplitPaneFixture(this.robot, this.findByType(JSplitPane.class));
    }

    @Override
    public JSplitPaneFixture splitPane(GenericTypeMatcher<? extends JSplitPane> matcher) {
        return new JSplitPaneFixture(this.robot, this.find(matcher));
    }

    @Override
    public JSplitPaneFixture splitPane(String name) {
        return new JSplitPaneFixture(this.robot, this.findByName(name, JSplitPane.class));
    }

    @Override
    public JTabbedPaneFixture tabbedPane() {
        return new JTabbedPaneFixture(this.robot, this.findByType(JTabbedPane.class));
    }

    @Override
    public JTabbedPaneFixture tabbedPane(GenericTypeMatcher<? extends JTabbedPane> matcher) {
        return new JTabbedPaneFixture(this.robot, this.find(matcher));
    }

    @Override
    public JTabbedPaneFixture tabbedPane(String name) {
        return new JTabbedPaneFixture(this.robot, this.findByName(name, JTabbedPane.class));
    }

    @Override
    public JTableFixture table() {
        return new JTableFixture(this.robot, this.findByType(JTable.class));
    }

    @Override
    public JTableFixture table(GenericTypeMatcher<? extends JTable> matcher) {
        return new JTableFixture(this.robot, this.find(matcher));
    }

    @Override
    public JTableFixture table(String name) {
        return new JTableFixture(this.robot, this.findByName(name, JTable.class));
    }

    @Override
    public JTextComponentFixture textBox() {
        return new JTextComponentFixture(this.robot, this.findByType(JTextComponent.class));
    }

    @Override
    public JTextComponentFixture textBox(GenericTypeMatcher<? extends JTextComponent> matcher) {
        return new JTextComponentFixture(this.robot, this.find(matcher));
    }

    @Override
    public JTextComponentFixture textBox(String name) {
        return new JTextComponentFixture(this.robot, this.findByName(name, JTextComponent.class));
    }

    @Override
    public JToggleButtonFixture toggleButton() {
        return new JToggleButtonFixture(this.robot, this.findByType(JToggleButton.class));
    }

    @Override
    public JToggleButtonFixture toggleButton(GenericTypeMatcher<? extends JToggleButton> matcher) {
        return new JToggleButtonFixture(this.robot, this.find(matcher));
    }

    @Override
    public JToggleButtonFixture toggleButton(String name) {
        return new JToggleButtonFixture(this.robot, this.findByName(name, JToggleButton.class));
    }

    @Override
    public JToolBarFixture toolBar() {
        return new JToolBarFixture(this.robot, this.findByType(JToolBar.class));
    }

    @Override
    public JToolBarFixture toolBar(GenericTypeMatcher<? extends JToolBar> matcher) {
        return new JToolBarFixture(this.robot, this.find(matcher));
    }

    @Override
    public JToolBarFixture toolBar(String name) {
        return new JToolBarFixture(this.robot, this.findByName(name, JToolBar.class));
    }

    @Override
    public JTreeFixture tree() {
        return new JTreeFixture(this.robot, this.findByType(JTree.class));
    }

    @Override
    public JTreeFixture tree(GenericTypeMatcher<? extends JTree> matcher) {
        return new JTreeFixture(this.robot, this.find(matcher));
    }

    @Override
    public JTreeFixture tree(String name) {
        return new JTreeFixture(this.robot, this.findByName(name, JTree.class));
    }

    protected final <C extends Component> C findByType(Class<C> type) {
        return this.finder().findByType((Container)this.target, type, this.requireShowing());
    }

    protected final <C extends Component> C findByName(String name, Class<C> type) {
        return this.finder().findByName((Container)this.target, name, type, this.requireShowing());
    }

    protected final <C extends Component> C find(GenericTypeMatcher<? extends C> matcher) {
        return this.finder().find((Container)this.target, matcher);
    }

    @Override
    public <C extends Component, F extends ComponentFixture<C>> F with(ComponentFixtureExtension<C, F> extension) {
        return extension.createFixture(this.robot, (Container)this.target);
    }

    protected final ComponentFinder finder() {
        return this.robot.finder();
    }
}

