/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Objects;
import org.fest.util.Strings;

final class JTableMatchingCellQuery {
    @RunsInEDT
    static TableCell cellWithValue(final JTable table, final String value, final JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            protected TableCell executeInEDT() {
                return JTableMatchingCellQuery.findMatchingCell(table, value, cellReader);
            }
        });
    }

    @RunsInCurrentThread
    private static TableCell findMatchingCell(JTable table, String value, JTableCellReader cellReader) {
        int rCount = table.getRowCount();
        int cCount = table.getColumnCount();
        for (int r = 0; r < rCount; ++r) {
            for (int c = 0; c < cCount; ++c) {
                if (!JTableMatchingCellQuery.cellHasValue(table, r, c, value, cellReader)) continue;
                return TableCell.row(r).column(c);
            }
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find cell with value ", Strings.quote((String)value)}));
    }

    @RunsInCurrentThread
    private static boolean cellHasValue(JTable table, int row, int column, String value, JTableCellReader cellReader) {
        return Objects.areEqual((Object)value, (Object)cellReader.valueAt(table, row, column));
    }

    private JTableMatchingCellQuery() {
    }
}

