/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTabbedPane;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Strings;

final class JTabbedPaneTabIndexQuery {
    @RunsInCurrentThread
    static int indexOfTab(final JTabbedPane tabbedPane, final String title) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!Strings.match(title, tabbedPane.getTitleAt(i))) continue;
                    return i;
                }
                return -1;
            }
        });
    }

    private JTabbedPaneTabIndexQuery() {
    }
}

