/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComboBoxAccessibleEditorValidator;
import org.fest.swing.driver.JComboBoxContentQuery;
import org.fest.swing.driver.JComboBoxDropDownListFinder;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JComboBoxItemIndexValidator;
import org.fest.swing.driver.JComboBoxMatchingItemQuery;
import org.fest.swing.driver.JComboBoxSelectionValueQuery;
import org.fest.swing.driver.JComboBoxSetPopupVisibleTask;
import org.fest.swing.driver.JComboBoxSetSelectedIndexTask;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JComboBoxDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private final JComboBoxDropDownListFinder dropDownListFinder;
    private JComboBoxCellReader cellReader;

    public JComboBoxDriver(Robot robot) {
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.dropDownListFinder = new JComboBoxDropDownListFinder(robot);
        this.cellReader(new BasicJComboBoxCellReader());
    }

    @RunsInEDT
    public String[] contentsOf(JComboBox comboBox) {
        return JComboBoxContentQuery.contents(comboBox, this.cellReader);
    }

    @RunsInEDT
    public void selectItem(JComboBox comboBox, String value) {
        int index = JComboBoxMatchingItemQuery.matchingItemIndex(comboBox, value, this.cellReader);
        if (index < 0) {
            throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find item ", Strings.quote((String)value), " among the JComboBox contents (", Arrays.format((Object)this.contentsOf(comboBox)), ")"}));
        }
        this.selectItem(comboBox, index);
    }

    @RunsInEDT
    public void requireSelection(JComboBox comboBox, String value) {
        Object selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader);
        if (JComboBoxSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(comboBox).value(), "] No selection"}));
        }
        Assertions.assertThat((Object)selection).as(this.selectedIndexProperty(comboBox)).isEqualTo((Object)value);
    }

    @RunsInEDT
    public void requireNoSelection(JComboBox comboBox) {
        Object selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader);
        if (JComboBoxSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            return;
        }
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(comboBox).value(), "] Expecting no selection, but found:<", Strings.quote((Object)selection), ">"}));
    }

    public String value(JComboBox comboBox, int index) {
        return JComboBoxDriver.valueAsText(comboBox, index, this.cellReader);
    }

    @RunsInEDT
    private static String valueAsText(final JComboBox comboBox, final int index, final JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JComboBoxItemIndexValidator.validateIndex(comboBox, index);
                return cellReader.valueAt(comboBox, index);
            }
        });
    }

    private Description selectedIndexProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void selectItem(JComboBox comboBox, int index) {
        JComboBoxDriver.validateCanSelectItem(comboBox, index);
        this.showDropDownList(comboBox);
        this.selectItemAtIndex(comboBox, index);
        this.hideDropDownListIfVisible(comboBox);
    }

    @RunsInEDT
    private static void validateCanSelectItem(final JComboBox comboBox, final int index) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(comboBox);
                JComboBoxItemIndexValidator.validateIndex(comboBox, index);
            }
        });
    }

    @RunsInEDT
    void showDropDownList(JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, true);
    }

    @RunsInEDT
    private void selectItemAtIndex(JComboBox comboBox, int index) {
        JList dropDownList = this.dropDownListFinder.findDropDownList();
        if (dropDownList != null) {
            this.listDriver.selectItem(dropDownList, index);
            return;
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void hideDropDownListIfVisible(JComboBox comboBox) {
        this.dropDownVisibleThroughUIDelegate(comboBox, false);
    }

    @RunsInEDT
    private void dropDownVisibleThroughUIDelegate(JComboBox comboBox, boolean visible) {
        JComboBoxSetPopupVisibleTask.setPopupVisible(comboBox, visible);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void replaceText(JComboBox comboBox, String text) {
        this.selectAllText(comboBox);
        this.enterText(comboBox, text);
    }

    @RunsInEDT
    public void selectAllText(JComboBox comboBox) {
        Component editor = JComboBoxDriver.accessibleEditorOf(comboBox);
        if (!(editor instanceof JComponent)) {
            return;
        }
        this.focus(editor);
        this.invokeAction((JComponent)editor, "select-all");
    }

    @RunsInEDT
    private static Component accessibleEditorOf(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                JComboBoxAccessibleEditorValidator.validateEditorIsAccessible(comboBox);
                return comboBox.getEditor().getEditorComponent();
            }
        });
    }

    @RunsInEDT
    public void enterText(JComboBox comboBox, String text) {
        JComboBoxDriver.inEdtValidateEditorIsAccessible(comboBox);
        this.focus(comboBox);
        this.robot.enterText(text);
    }

    @RunsInEDT
    private static void inEdtValidateEditorIsAccessible(final JComboBox comboBox) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JComboBoxAccessibleEditorValidator.validateEditorIsAccessible(comboBox);
            }
        });
    }

    @RunsInEDT
    public JList dropDownList() {
        JList list = this.dropDownListFinder.findDropDownList();
        if (list == null) {
            throw this.listNotFound();
        }
        return list;
    }

    private ComponentLookupException listNotFound() {
        throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
    }

    @RunsInEDT
    public void requireEditable(JComboBox comboBox) {
        this.assertEditable(comboBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(JComboBox comboBox) {
        this.assertEditable(comboBox, false);
    }

    @RunsInEDT
    private void assertEditable(JComboBox comboBox, boolean expected) {
        Assertions.assertThat((boolean)JComboBoxEditableQuery.isEditable(comboBox)).as(JComboBoxDriver.editableProperty(comboBox)).isEqualTo(expected);
    }

    @RunsInEDT
    private static Description editableProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void cellReader(JComboBoxCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }
}

