/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.awt.Dialog;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogMatcher
extends NamedComponentMatcherTemplate<Dialog> {
    private Object title;

    public static DialogMatcher withName(String name) {
        return new DialogMatcher(name, ANY);
    }

    public static DialogMatcher withTitle(String title) {
        return new DialogMatcher(ANY, (Object)title);
    }

    public static DialogMatcher any() {
        return new DialogMatcher(ANY, ANY);
    }

    private DialogMatcher(Object name, Object title) {
        super(Dialog.class, name);
        this.title = title;
    }

    public DialogMatcher andTitle(String newTitle) {
        this.title = newTitle;
        return this;
    }

    public DialogMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(Dialog dialog) {
        if (!this.isNameMatching(dialog.getName())) {
            return false;
        }
        return this.arePropertyValuesMatching(this.title, dialog.getTitle());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", this.quotedName(), ", ", "title=", this.quoted(this.title), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]"});
    }
}

