/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.timing.Condition;

public final class ComponentFoundCondition
extends Condition {
    private final ComponentFinder finder;
    private final ComponentMatcher matcher;
    private final Container root;
    private Component found;

    public ComponentFoundCondition(String description, ComponentFinder finder, ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(String description, ComponentFinder finder, ComponentMatcher matcher, Container root) {
        this((Description)new BasicDescription(description), finder, matcher, root);
    }

    public ComponentFoundCondition(Description description, ComponentFinder finder, ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(Description description, ComponentFinder finder, ComponentMatcher matcher, Container root) {
        super(description);
        this.finder = finder;
        this.matcher = matcher;
        this.root = root;
    }

    public boolean test() {
        ArrayList<Component> allFound = new ArrayList<Component>(this.finder.findAll(this.root, this.matcher));
        if (allFound.size() != 1) {
            return false;
        }
        this.found = (Component)allFound.get(0);
        return true;
    }

    public Component found() {
        return this.found;
    }
}

