#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <regex.h>

#include <errno.h>
extern int errno;
int syserr;

#define ALLOC_STEP 1000
regex_t regexp;
int size_files=0, used_files=0, i=0;
char **files, *wyjscie;
regmatch_t matchpos;

void add_file(const char *dir) {
DIR *kat;
struct dirent *wpis;
static struct stat pozycja;
char *tmp;

errno=0;
if (!(kat=opendir(dir))) {
	syserr=errno;
	fprintf(stderr,"Failed to read directory %s\nError code: %s\n",dir,	strerror(errno));
	return;
}

while ((wpis=readdir(kat))) {

if ((wpis->d_name)[0]=='.') continue;

tmp=malloc(strlen(wpis->d_name)+strlen(dir)+2);
strcpy(tmp,dir);
strcat(tmp,"/");
strcat(tmp,wpis->d_name);
if(!stat(tmp,&pozycja)) {
	if (!(S_ISREG(pozycja.st_mode)||S_ISLNK(pozycja.st_mode)||S_ISDIR(pozycja.st_mode))) {
		free(tmp);
		continue;
	}

	if (S_ISDIR(pozycja.st_mode)) {
		add_file(tmp);
		free(tmp);
		continue;
	} else {
		if (regexec(&regexp,wpis->d_name, 0, &matchpos, 0)==REG_NOMATCH) { continue;}
		if (used_files==size_files) {
			//trzeba powiększyć tablicę, bo skończyło się miejsce
			size_files+=ALLOC_STEP;
			files=realloc(files,size_files*sizeof(char *));
			if (!files) {
				fprintf(stderr,"Błąd w alokacji!\n");
				exit(-1);
			}
		}
		files[used_files]=tmp;
		used_files++;
	}
}
}
closedir(kat);
return;
}

char *randomly_select_font(const char *wejscie){

files=NULL;wyjscie=NULL;size_files=0;used_files=0;i=0;

regcomp(&regexp,"^.*\\.ttf$",REG_ICASE||REG_NOSUB);

add_file(wejscie);

if (used_files==0) {
	return NULL;
}

i=rand()%used_files;
wyjscie=malloc(strlen(files[i])+1);
strcpy(wyjscie,files[i]);

for (i=0;i<used_files;i++) free(files[i]);
free(files);

return wyjscie;
}

char *randomly_select_image(const char *wejscie){

files=NULL;wyjscie=NULL;size_files=0;used_files=0;i=0;

regcomp(&regexp,"^.*\\.(bmp|jpg|jpeg|png|tiff|tif|tga|gif|pcx|xpm|pnm|ppm|xbm)$",REG_ICASE||REG_NOSUB);

add_file(wejscie);

if (used_files==0) {
	return NULL;
}

i=rand()%used_files;
wyjscie=malloc(strlen(files[i])+1);
strcpy(wyjscie,files[i]);

for (i=0;i<used_files;i++) free(files[i]);
free(files);

return wyjscie;
}

