namespace distortion1 {
// generated from file '../src/faust/distortion1.dsp'

int 	iVec0[2];
double 	fConst0;
double 	fConst1;
double 	fConst2;
double 	fConst3;
double 	fConst4;
double 	fConst5;
double 	fConst6;
double 	fRec2[2];
FAUSTFLOAT 	fslider0;
int 	IOTA;
double 	fVec1[4096];
FAUSTFLOAT 	fslider1;
double 	fRec3[2];
FAUSTFLOAT 	fcheckbox0;
FAUSTFLOAT 	fentry0;
double 	fConst7;
FAUSTFLOAT 	fentry1;
double 	fVec2[2];
double 	fRec5[2];
double 	fRec4[2];
FAUSTFLOAT 	fcheckbox1;
FAUSTFLOAT 	fslider2;
FAUSTFLOAT 	fslider3;
double 	fVec3[2];
double 	fRec9[2];
double 	fVec4[2];
double 	fRec8[2];
double 	fRec7[3];
double 	fRec6[3];
FAUSTFLOAT 	fcheckbox2;
double 	fVec5[3];
double 	fConst8;
double 	fConst9;
double 	fConst10;
double 	fConst11;
double 	fConst12;
double 	fRec1[3];
FAUSTFLOAT 	fslider4;
FAUSTFLOAT 	fslider5;
FAUSTFLOAT 	fslider6;
double 	fRec10[2];
double 	fVec6[3];
double 	fRec0[3];
double 	fVec7[2];
double 	fRec14[2];
double 	fVec8[2];
double 	fRec13[2];
double 	fRec12[3];
double 	fRec11[3];
int	fSamplingFreq;

void init(int samplingFreq)
{
	fSamplingFreq = samplingFreq;
	for (int i=0; i<2; i++) iVec0[i] = 0;
	fConst0 = (6.283185307179586 * (max(0, ((0.5 * fSamplingFreq) - 1e+02)) / fSamplingFreq));
	fConst1 = cos(fConst0);
	fConst2 = (1.316227766016838 * fConst1);
	fConst3 = (0 - (2 * (0 - (0.683772233983162 + fConst2))));
	fConst4 = (0.683772233983162 * fConst1);
	fConst5 = (0.005623413251903491 * sin(fConst0));
	fConst6 = (fConst5 - (fConst4 + 1.316227766016838));
	for (int i=0; i<2; i++) fRec2[i] = 0;
	IOTA = 0;
	for (int i=0; i<4096; i++) fVec1[i] = 0;
	for (int i=0; i<2; i++) fRec3[i] = 0;
	fConst7 = (3.141592653589793 / fSamplingFreq);
	for (int i=0; i<2; i++) fVec2[i] = 0;
	for (int i=0; i<2; i++) fRec5[i] = 0;
	for (int i=0; i<2; i++) fRec4[i] = 0;
	for (int i=0; i<2; i++) fVec3[i] = 0;
	for (int i=0; i<2; i++) fRec9[i] = 0;
	for (int i=0; i<2; i++) fVec4[i] = 0;
	for (int i=0; i<2; i++) fRec8[i] = 0;
	for (int i=0; i<3; i++) fRec7[i] = 0;
	for (int i=0; i<3; i++) fRec6[i] = 0;
	for (int i=0; i<3; i++) fVec5[i] = 0;
	fConst8 = (fConst5 + fConst4);
	fConst9 = (0.31622776601683794 * (1.316227766016838 - fConst8));
	fConst10 = (0.31622776601683794 * ((fConst5 + 1.316227766016838) - fConst4));
	fConst11 = (0 - (0.6324555320336759 * (fConst2 - 0.683772233983162)));
	fConst12 = (1.0 / (1.316227766016838 + fConst8));
	for (int i=0; i<3; i++) fRec1[i] = 0;
	for (int i=0; i<2; i++) fRec10[i] = 0;
	for (int i=0; i<3; i++) fVec6[i] = 0;
	for (int i=0; i<3; i++) fRec0[i] = 0;
	for (int i=0; i<2; i++) fVec7[i] = 0;
	for (int i=0; i<2; i++) fRec14[i] = 0;
	for (int i=0; i<2; i++) fVec8[i] = 0;
	for (int i=0; i<2; i++) fRec13[i] = 0;
	for (int i=0; i<3; i++) fRec12[i] = 0;
	for (int i=0; i<3; i++) fRec11[i] = 0;
}

void compute(int count, float *input0, float *output0)
{
	double 	fSlow0 = (1.0 - fslider0);
	double 	fSlow1 = fslider1;
	int 	iSlow2 = int((int((fSlow1 - 1)) & 4095));
	int 	iSlow3 = int((int(fSlow1) & 4095));
	int 	iSlow4 = int(fcheckbox0);
	double 	fSlow5 = (1.0 / tan((fConst7 * fentry0)));
	double 	fSlow6 = (1 + fSlow5);
	double 	fSlow7 = (0 - ((1 - fSlow5) / fSlow6));
	double 	fSlow8 = (1.0 / tan((fConst7 * fentry1)));
	double 	fSlow9 = (1 + fSlow8);
	double 	fSlow10 = (0 - ((1 - fSlow8) / fSlow9));
	double 	fSlow11 = (1.0 / fSlow9);
	double 	fSlow12 = (0 - fSlow5);
	double 	fSlow13 = (1.0 / fSlow6);
	int 	iSlow14 = int(fcheckbox1);
	double 	fSlow15 = tan((fConst7 * fslider2));
	double 	fSlow16 = (2 * (1 - (1.0 / faustpower<2>(fSlow15))));
	double 	fSlow17 = (1.0 / fSlow15);
	double 	fSlow18 = (1 + ((fSlow17 - 0.7653668647301795) / fSlow15));
	double 	fSlow19 = (1.0 / (1 + ((0.7653668647301795 + fSlow17) / fSlow15)));
	double 	fSlow20 = (1 + ((fSlow17 - 1.8477590650225735) / fSlow15));
	double 	fSlow21 = (1.0 / (1 + ((1.8477590650225735 + fSlow17) / fSlow15)));
	double 	fSlow22 = (fConst7 * fslider3);
	double 	fSlow23 = (1.0 / (1 + fSlow22));
	double 	fSlow24 = (1 - fSlow22);
	int 	iSlow25 = int(fcheckbox2);
	double 	fSlow26 = pow(1e+01,(2 * fslider4));
	double 	fSlow27 = fslider5;
	double 	fSlow28 = (0.0010000000000000009 * pow(10,(0.05 * (fslider6 - 10))));
	for (int i=0; i<count; i++) {
		iVec0[0] = 1;
		fRec2[0] = ((1e-20 * (1 - iVec0[1])) - fRec2[1]);
		double fTemp0 = (double)input0[i];
		double fTemp1 = (fTemp0 + (fSlow0 * fRec3[1]));
		fVec1[IOTA&4095] = fTemp1;
		fRec3[0] = (0.5 * (fVec1[(IOTA-iSlow3)&4095] + fVec1[(IOTA-iSlow2)&4095]));
		double fTemp2 = ((iSlow4)?fRec3[0]:fTemp0);
		double fTemp3 = (fTemp2 + (2 * fRec2[0]));
		fVec2[0] = fTemp3;
		fRec5[0] = ((fSlow11 * (fVec2[0] + fVec2[1])) + (fSlow10 * fRec5[1]));
		fRec4[0] = ((fSlow13 * ((fSlow12 * fRec5[1]) + (fSlow5 * fRec5[0]))) + (fSlow7 * fRec4[1]));
		double fTemp4 = ((iSlow14)?fRec4[0]:(fTemp2 + fRec2[0]));
		double fTemp5 = (1e-20 + (fRec2[0] + fTemp4));
		fVec3[0] = (fSlow23 * fTemp5);
		fRec9[0] = ((fSlow23 * (fTemp5 + (fSlow24 * fRec9[1]))) - fVec3[1]);
		fVec4[0] = (fSlow23 * fRec9[0]);
		fRec8[0] = ((fSlow23 * (fRec9[0] + (fSlow24 * fRec8[1]))) - fVec4[1]);
		fRec7[0] = (fRec8[0] - (fSlow21 * ((fSlow20 * fRec7[2]) + (fSlow16 * fRec7[1]))));
		fRec6[0] = ((fSlow21 * (fRec7[2] + (fRec7[0] + (2 * fRec7[1])))) - (fSlow19 * ((fSlow18 * fRec6[2]) + (fSlow16 * fRec6[1]))));
		double fTemp6 = ((iSlow25)?(fSlow19 * (fRec6[2] + (fRec6[0] + (2 * fRec6[1])))):(1e-20 + fTemp4));
		fVec5[0] = fTemp6;
		fRec1[0] = (fConst12 * ((((fConst11 * fVec5[1]) + (fConst10 * fVec5[0])) + (fConst9 * fVec5[2])) + ((fConst6 * fRec1[2]) + (fConst3 * fRec1[1]))));
		double fTemp7 = max(-1, min(1, (fSlow27 + (fSlow26 * fRec1[0]))));
		fRec10[0] = (fSlow28 + (0.999 * fRec10[1]));
		double fTemp8 = ((fRec10[0] * fTemp7) * (1 - (0.3333333333333333 * faustpower<2>(fTemp7))));
		fVec6[0] = fTemp8;
		fRec0[0] = (fConst12 * ((((fConst11 * fVec6[1]) + (fConst10 * fVec6[0])) + (fConst9 * fVec6[2])) + ((fConst6 * fRec0[2]) + (fConst3 * fRec0[1]))));
		double fTemp9 = (fRec2[0] + fRec0[0]);
		fVec7[0] = (fSlow23 * fTemp9);
		fRec14[0] = ((fSlow23 * (fTemp9 + (fSlow24 * fRec14[1]))) - fVec7[1]);
		fVec8[0] = (fSlow23 * fRec14[0]);
		fRec13[0] = ((fSlow23 * (fRec14[0] + (fSlow24 * fRec13[1]))) - fVec8[1]);
		fRec12[0] = (fRec13[0] - (fSlow21 * ((fSlow20 * fRec12[2]) + (fSlow16 * fRec12[1]))));
		fRec11[0] = ((fSlow21 * (fRec12[2] + (fRec12[0] + (2 * fRec12[1])))) - (fSlow19 * ((fSlow18 * fRec11[2]) + (fSlow16 * fRec11[1]))));
		output0[i] = (FAUSTFLOAT)((iSlow25)?(fSlow19 * (fRec11[2] + (fRec11[0] + (2 * fRec11[1])))):fRec0[0]);
		// post processing
		fRec11[2] = fRec11[1]; fRec11[1] = fRec11[0];
		fRec12[2] = fRec12[1]; fRec12[1] = fRec12[0];
		fRec13[1] = fRec13[0];
		fVec8[1] = fVec8[0];
		fRec14[1] = fRec14[0];
		fVec7[1] = fVec7[0];
		fRec0[2] = fRec0[1]; fRec0[1] = fRec0[0];
		fVec6[2] = fVec6[1]; fVec6[1] = fVec6[0];
		fRec10[1] = fRec10[0];
		fRec1[2] = fRec1[1]; fRec1[1] = fRec1[0];
		fVec5[2] = fVec5[1]; fVec5[1] = fVec5[0];
		fRec6[2] = fRec6[1]; fRec6[1] = fRec6[0];
		fRec7[2] = fRec7[1]; fRec7[1] = fRec7[0];
		fRec8[1] = fRec8[0];
		fVec4[1] = fVec4[0];
		fRec9[1] = fRec9[0];
		fVec3[1] = fVec3[0];
		fRec4[1] = fRec4[0];
		fRec5[1] = fRec5[0];
		fVec2[1] = fVec2[0];
		fRec3[1] = fRec3[0];
		IOTA = IOTA+1;
		fRec2[1] = fRec2[0];
		iVec0[1] = iVec0[0];
	}
}

static struct RegisterParams { RegisterParams(); } RegisterParams;
RegisterParams::RegisterParams()
{
	registerVar("distortion1.low_highpass.on_off","low highpass","B","",&fcheckbox1, 0.0, 0.0, 1.0, 1.0);
	registerVar("distortion1.resonator.on_off","resonat","B","",&fcheckbox0, 0.0, 0.0, 1.0, 1.0);
	registerVar("distortion1.low_highcutoff.on_off","low highcutoff","B","",&fcheckbox2, 0.0, 0.0, 1.0, 1.0);
	registerVar("distortion1.low_highpass.low_freq","low freq","S","",&fentry1, 5e+03, 2e+01, 1.2e+04, 1e+01);
	registerVar("distortion1.low_highpass.high_freq","high freq","S","",&fentry0, 1.3e+02, 2e+01, 7.04e+03, 1e+01);
	registerVar("distortion1.gain","","S","",&fslider6, 2.0, -1e+01, 1e+01, 0.1);
	registerVar("distortion1.level","","S","",&fslider5, 0.01, 0.0, 0.5, 0.01);
	registerVar("distortion1.drive","","S","",&fslider4, 0.64, 0.0, 1.0, 0.01);
	registerVar("distortion1.low_highcutoff.low_freq","low freq","S","low-freq cutoff Hz",&fslider3, 1.3e+02, 2e+01, 1e+03, 1e+01);
	registerVar("distortion1.low_highcutoff.high_freq","high freq","S","high-freq cutoff Hz",&fslider2, 5e+03, 1e+03, 1.2e+04, 1e+01);
	registerVar("distortion1.vibrato","","S","",&fslider1, 1.0, 0.0, 1.0, 0.01);
	registerVar("distortion1.trigger","","S","",&fslider0, 0.12, 0.0, 1.0, 0.01);
	registerInit("distortion1", init);
}

} // end namespace distortion1
