headings 10
Tests 21
add
addto
adf
arch
chow
coeffsum
coint
coint2
cusum
hausman
leverage
lmtest
meantest
omit
omitfrom
reset
restrict
runs
testuhat
vartest
vif
Estimation 21
ar
arima
corc
equation
garch
hccm
hilu
hsk
lad
logistic
logit
mpols
nls
ols
probit
pwe
system
tobit
tsls
var
wls
Graphs 6
boxplot
gnuplot
graph
plot
rmplot
scatters
Dataset 15
data
delete
genr
info
setinfo
labels
nulldata
open
panel
rename
setobs
setmiss
smpl
store
varlist
Statistics 7
corr
corrgm
freq
pca
pergm
spearman
summary
Utilities 6
criteria
help
modeltab
pvalue
quit
shell
Transformations 6
diff
lags
ldiff
logs
rhodiff
square
Programming 9
else
end
endif
endloop
function
if
loop
run
set
Printing 5
eqnprint
outfile
print
printf
tabprint
Prediction 2
fcast
fcasterr

# add Tests

Argumento: 	<@var="listavar"> 
Opciones: 	<@lit="--vcv"> (mostrar matriz de covarianzas)
		<@lit="--quiet"> (no muetra las estimaciones del modelo aumentado)
Ejemplos: 	<@lit="add 5 7 9">
		<@lit="add xx yy zz">

Debe utilizarse después de una instrucción de estimación. Las variables de <@var="listavar"> se añaden al modelo anterior y se estima el nuevo modelo. Si se añade más de una variable, se presenta el estadístico <@itl="F"> para las variables añadidas (sólo para el método MCO) junto con su valor-p. Un valor-p inferior a 0.05 indica que los coeficientes son conjuntamente significativos al nivel del 5 por ciento. 

Si se usa la opción <@lit="--quiet"> el resultado que se muestra es sólo el estadístico para el contraste de significación conjunta de las variables añadidas, en los demás casos se presentan también las estimaciones del modelo aumentado. En este último caso, la opción <@lit="--vcv"> hace que también se presente la matriz de covarianzas de los coeficientes. 

Menú gráfico: Ventana de Modelo, /Contrastes/Añadir variables

# addto Tests

Argumentos: 	<@var="ID_modelo"> <@var="listavar"> 
Opción: 	<@lit="--quiet"> (no mostrar las estimaciones del modelo aumentado)
Ejemplo: 	<@lit="addto 2 5 7 9">

Funciona como la instrucción <@lit="add">, salvo que Vd. especifica un modelo previo (usando su identificador --ID-- de modelo, que se presenta al principio de los resultados del modelo) que se toma como base para añadir las variables. En el ejemplo de arriba se añaden las variables números 5, 7 y 9 al Modelo 2. 

Menú gráfico: Ventana de Modelo, /Contrastes/añadir variables

# adf Tests

Argumentos: 	<@var="orden"> <@var="nombre_var"> 
Ejemplo: 	<@lit="adf 2 x1">

Calcula los estadísticos para dos contrastes de Dickey-Fuller. En cada caso la hipótesis nula es que la variable seleccionada presenta una raíz unitaria. El primero es un estadístico <@itl="t"> basado en el modelo 

  <@fig="adf1">

La hipótesis nula es que <@itl="g"> = 0. En el segundo contraste (aumentado) se realiza la estimación de una regresión no retringida (cuyos regresores son una constante, una tendencia temporal, el primer retardo de la variable y <@var="orden"> retardos de la primera diferencia) y una versión restringida (quitando la tendencia temporal y el primer retardo). El estadístico de contraste es 

  <@fig="adf2">

donde <@itl="T"> es el tamaño de la muestra, <@itl="k"> el número de parámetros del modelo no restringido, y los subíndices <@itl="u"> y <@itl="r"> denotan el modelo no restringido y el restringido respectivamente. Hay que señalar que los valores críticos para estos estadísticos no son los habituales; se muestra el valor p cuando es posible determinarlo. 

Menú gráfico: /Variable/Contraste aumentado de Dickey-Fuller

# ar Estimation

Argumentos: 	<@var="retardos"> ; <@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
Ejemplo: 	<@lit="ar 1 3 4 ; y 0 x1 x2 x3">

Computa las estimaciones de los parámetros usando el procedimiento iterativo generalizado de Cochrane–Orcutt (ver Sección 9.5 del libro de Ramanathan). Las iteraciones terminan cuando dos sumas de cuadrados residuales sucesivas no difieren en más del 0.005 por ciento o después de 20 iteraciones. 

<@var="retardos"> es una lista de retardos de los residuos, que termina con un punto y coma. En el ejemplo anterior el término de error se especifica como 

  <@fig="arlags">

Menú gráfico: /Modelo/Serie temporal/Estimación autorregresiva

# arch Tests

Argumentos: 	<@var="orden"> <@var="vardep"> <@var="varindeps"> 
Ejemplo: 	<@lit="arch 4 y 0 x1 x2 x3">

Contrasta la existencia de ARCH (Autoregressive Conditional Heteroskedasticity -- Heterocedasticidad condicional autorregresiva) del orden especificado, en el modelo. Si el estadístico de contraste LM tiene un valor p inferior a 0.10, entonces también se realiza la estimación del modelo ARCH. Si la predicción de la varianza de cualquier observación, en la regresión auxiliar, no es positiva entonces se usa en su lugar el correspondiente residuo al cuadrado. Después se realiza una estimación por mínimos cuadrados ponderados sobre el modelo original. 

Ver también <@ref="garch">. 

Menú gráfico: Ventana de Modelo, /Contrastes/ARCH

# arima Estimation

Argumentos: 	<@var="p"> <@var="q"> ; <@var="vardep"> [ <@var="varindeps"> ] 
Opciones: 	<@lit="--native"> (Usar rutina nativa plugin (por defecto))
		<@lit="--x-12-arima"> (usar el programa X-12-ARIMA para realizar la estimación)
		<@lit="--verbose"> (mostrar detalles de las iteraciones)
		<@lit="--vcv"> (mostrar la matriz de covarianzas)
Ejemplos: 	<@lit="arma 1 2 ; y">
		<@lit="arma 2 2 ; y 0 x1 x2 --verbose">

Si no se da una lista <@var="varindeps">, estima un modelo ARMA (Autoregressive, Moving Average) univariante. Los valores enteros <@var="p"> y <@var="q"> representan los órdenes AR y MA respectivamente. Si se añade una lista <@var="varindeps">, el modelo pasa a ser un ARMAX. 

Por defecto se usa la función "nativa" ARMA de gretl; en el caso de un modelo ARMA univariante se puede usar X-12-ARIMA en su lugar (si está instalado el paquete X-12-ARIMA para gretl). 

La sopciones dadas arriba pueden combinarse, pero la matriz de covarianzas no está disponible cuando se realiza la estimación mediante X-12-ARIMA. 

El algoritmo ARMA nativo de gretl ha sido, en su mayor parte, creado por Riccardo "Jack" Lucchetti. Utiliza un procedimiento de máxima verosimilitud condicional, implementado por medio de la estimación por mínimos cuadrados iterativos de la regresión del producto externo del gradiente (OPG, outer product of the gradient regression). Ver <@pdf="el manual de gretl"> para entender la lógica de este procedimiento. Los coeficientes AR (y los de cualquier regresor adicional) se inicializan por medio de la estimación por MCO de un AR, y los coeficientes MA se inicializan asignándoles valor cero. 

El valor del coeficiente AIC para los modelos ARMA se calcula de acuerdo con la definición usada en el programa X-12-ARIMA, es decir 

  <@fig="aic">

donde <@itl="L"> es la log-verosimilitud y <@itl="k"> es el número total de parámetros estimados. La "frecuencia" que se presenta asociada a las raíces AR y MA es el valor λ que soluciona 

  <@fig="lambda">

donde <@itl="z"> es la raíz en cuestión y <@itl="r"> es su módulo. 

Menú gráfico: /Variable/Modelo ARMA, /Modelo/Serie temporal/ARMAX
Otro acceso: Menú emergente de la ventana principal (selección simple)

# boxplot Graphs

Argumento: 	<@var="listavar"> 
Opción: 	<@lit="--notches"> (presenta el intervalo de confianza 90 por ciento para la mediana)

Estos gráficos (debidos a Tukey y Chambers) muestran la distribución de una variable. La caja central recoge el 50 por ciento intermedio de los datos, es decir, está acotada por el primero y tercer cuartiles. Las "patillas" se extienden hasta los valores mínimo y máximo. Se dibuja una línea a lo largo de la caja en el lugar de la mediana. 

En el caso de gráficos de caja recortados, el recorte muestra los límites de un intervalo de aproximadamente el 90 por ciento de confianza para la mediana. Este intervalo se obtienen por el método bootstrap. 

Después de cada variable especificada en la instrucción boxplot, se puede añadir una expresión booleana entre paréntesis para limitar la muestra para la variable en cuestión. Debe de insertarse un espacio entre el nombre o número de la variable y la expresión. Supongamos que usted tiene valores de los salarios de hombres y mujeres, y tiene una variable ficticia <@lit="SEXO"> con valor 1 para los hombres y 0 para las mujeres. En este caso usted puede dibujar gráficos de caja comparativos usando la siguiente <@var="listavar">: 

<code>          
	salary (GENDER=1) salary (GENDER=0)
</code>

Algunos detalles de los gráficos de caja de gretl pueden controlarse por medio de un fichero (de texto plano) llamado <@lit=".boxplotrc">. Para más detalles sobre esto ver <@pdf="el manual de gretl">. 

Menú gráfico: /Datos/Gráficos/Gráficos de caja

# chow Tests

Argumento: 	<@var="obs"> 
Ejemplos: 	<@lit="chow 25">
		<@lit="chow 1988:1">

Primero debe ejecutarse una regresión por MCO. Crea una variable ficticia que es igual a 1 desde el punto de corte especificado en <@var="obs"> hasta el final de la muestra y 0 en el resto. También crea los términos de interacción entre esta variable ficticia y las variables independientes originales. Se ejecuta una regresión aumentada incluyendo estos términos y se calcula un estadístico <@itl="F">, tomando la regresión aumentada como 'no restringida' y la original como 'restringida'. Este estadístico es adecuado para contrastar la hipótesis nula de que no hay cambio estructural en el punto de ruptura indicado. 

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste de Chow

# coeffsum Tests

Argumento: 	<@var="listavar"> 
Ejemplo: 	<@lit="coeffsum xt xt_1 xr_2">

Debe ejecutarse después de una regresión. Calcula la suma de los coeficientes de las variables de la lista <@var="listavar">. Presenta la suma junto con su desviación típica y el valor p para la hipótesis nula de que la suma es cero. 

Hay que señalar la diferencia entre esta instrucción y <@ref="omit">, que contrasta la hipótesis nula de que los coeficientes de un subconjunto de variables independientes son <@itl="todos"> iguales a cero zero. 

Menú gráfico: Ventana de Modelo, /Contrastes/Suma de coeficientes

# coint Tests

Argumentos: 	<@var="orden"> <@var="vardep"> <@var="varindeps"> 
Ejemplo: 	<@lit="coint 4 y x1 x2">

Contraste de cointegración de Engle–Granger. Esta instrucción realiza los contrastes de Dickey–Fuller aumentados de la hipótesis nula de que cada una de las variables de la lista tiene una raíz unitaria, usando el orden de retardos dado. Se estima la ecuación cointegrante y se realiza un contraste ADF sobre los residuos de esta regresión. También se presenta el estadístico de Durbin–Watson para la regresión cointegrante. Hay que señalar que ninguno de estos estadísticos de contraste puede compararse con las tablas estadísticas usuales. 

Menú gráfico: /Modelo/Serie temporal/Contrates de cointegración/Engle-Granger

# coint2 Tests

Argumentos: 	<@var="orden"> <@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--verbose"> (mostrar los detalles de las regresiones auxiliares)
Ejemplos: 	<@lit="coint2 2 y x">
		<@lit="coint2 4 y x1 x2 --verbose">

Realiza el contraste de la traza de Johansen para contrastar cointegración entre las variables de la lista para el orden dado. Los valores críticos se computan por medio de la aproximación gamma de J. Doornik (Doornik, 1998). Para detalles sobre este contraste ver el libro de Hamilton, <@itl="Time Series Analysis"> (1994), Capítulo 20. 

Se presenta aquí la siguiente tabla como guía para la interpretación de los resultados ofrecidos por el contraste, para el caso de 3 variables. <@lit="H0"> denota la hipótesis nula, <@lit="H1"> la hipótesis alternativa y <@lit="c"> el número de relaciones cointegrantes. 

<code>          
            Rango   Contraste de la traza     Contraste Lmax 
                          H0     H1              H0     H1
             ---------------------------------------------------
              0          c = 0  c = 3          c = 0  c = 1
              1          c = 1  c = 3          c = 1  c = 2
              2          c = 2  c = 3          c = 2  c = 3
             ---------------------------------------------------
</code>

Menú gráfico: /Modelo/Serie temporal/Contraste de cointegración/Johansen

# corc Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
Ejemplo: 	<@lit="corc 1 0 2 4 6 7">

Computa estimaciones de los parámetros usando el procedimiento iterativo de Cochrane–Orcutt (ver Sección 9.4 del libro de Ramanathan). Las iteraciones finalizan cuando dos estimaciones sucesivas del coeficiente de autocorrelación no difieren en más de 0,001 o después de 20 iteraciones. 

Menú gráfico: /Modelo/Serie temporal/Cochrane-Orcutt

# corr Statistics

Argumento: 	[ <@var="listavar"> ] 
Ejemplo: 	<@lit="corr y x1 x2 x3">

Presenta los coeficientes de correlación por pares para las variables de <@var="listavar">, o para todas las variables del conjunto de datos, si no se proporciona <@var="listavar">. 

Menú gráfico: /Datos/Matriz de correlación
Otro acceso: Menú emergente de la ventana principal (cuando se hace 
      selección múltiple)

# corrgm Statistics

Argumentos: 	<@var="variable"> [ <@var="retardo_max"> ] 
Ejemplo: 	<@lit="corrgm x 12">

Presenta los valores de la función de autocorrelación para la <@var="variable"> especificada (por nombre o por número). Ver Ramanathan, Sección 11.7. Es por tanto <@fig="autocorr"> donde <@itl="u"><@sub="t"> es la <@itl="t">-ésima observación de la variable <@itl="u"> y <@itl="s"> es el número de retardos. 

También se presentan las autocorrelaciones parciales, siendo éstas los coeficientes una vez descontado el efecto de los demás retardos intervinientes. Esta instrucción también representa el correlograma y muestra el estadístico <@itl="Q"> de Box–Pierce para el contraste de la hipótesis nula de que la serie es "ruido blanco". Este se distribuye asintóticamente como una chi-cuadrado con grados de libertad igual al número de retardos utilizados. 

Si se especifica un valor para <@var="retardo_max"> entonces el tamaño del correlograma se limita como máximo a ese número de retardos, en los demás casos se determina automáticamente. 

Menú gráfico: /Variable/Correlograma
Otro acceso: Menú emergente de la ventana principal (cuando se hace 
      una selección simple)

# criteria Utilities

Argumentos: 	<@var="scr"> <@var="T"> <@var="k"> 
Ejemplo: 	<@lit="criteria 23.45 45 8">

Calcula los estadísticos de selección de modelos (ver Ramanathan, Sección 4.3), dados <@var="scr"> (suma de cuadrados de los residuos), el número de observaciones (<@itl="T">), y el número de coeficientes (<@itl="k">). <@itl="T">, <@itl="k">, y <@var="scr"> pueden ser valores numéricos o nombres de variables definidas previamente. 

# cusum Tests

Debe realizarse después de la estimación de un modelo por MCO. Realiza el contraste CUSUM de estabilidad de los parámetros. Se obtiene una serie de errores de predición (escalados) un período hacia adelante al ejecutar una serie de regresiones: la primera regresión utiliza las primeras <@itl="k"> observaciones y se usa para generar una predicción de la variable dependiente en la observación <@itl="k"> + 1; la segunda utiliza las primeras <@itl="k"> + 1 observaciones y genera una predicción para la observación <@itl="k"> + 2, y así sucesivamente (donde <@itl="k"> es el número de parámetros en el modelo original). Se muestra y se representa graicamente la suma acumulada de los errores de predicción escalados. La hipótesis nula de estabilidad en los parámetros se rechaza al nivel de significación del 5 por ciento si la suma acumulada se sale de la banda de 95 por ciento de confianza. 

También se presenta el estadístico <@itl="t"> de Harvey–Collier para contrastar la hipótesis nula de estabilidad de los parámetros. Para más detalles ver Capítulo 7 del libro de Greene <@itl="Econometric Analysis">. 

Menú gráfico: Ventana de Modelo, /Contrastes/CUSUM

# data Dataset

Argumento: 	<@var="listavar"> 

Lee las variables de <@var="listavar"> desde una base de datos (de gretl o RATS 4.0), que debe de haber sido abierta previamente usando la instrucción <@ref="open">. Además, se debe de establecer una frecuencia y un rango muestral para los datos usando las instrucciones <@ref="setobs"> y <@ref="smpl"> antes de usar esta orden. He aquí un ejemplo completo: 

<code>          
	open macrodat.rat
	setobs 4 1959:1
	smpl ; 1999:4
	data GDP_JP GDP_UK
</code>

Estas instrucciones abren una base de datos denominada <@lit="macrodat.rat">, establecen un conjunto de datos trimestral que empieza en el primer trimestre de 1959 y acaba en el cuarto trimestre de 1999, y después importan las series denominadas <@lit="GDP_JP"> y <@lit="GDP_UK">. 

Si las series que van a ser leídas son de una frecuencia mayor que el conjunto de datos actual, se debe especificar un método de compactado como en las siguientes líneas: 

<code>          
	data (compact=average) 
	LHUR PUNEW
</code>

Los cuatro métodos de compactado disponibles son "average" (promediar: toma la media de las observaciones de frecuencia mayor), "last" (última: usa la última observación), "first" y "sum". 

Menú gráfico: /Archivo/Revisar bases de datos

# delete Dataset

Argumento: 	[ <@var="listavar"> ] 

Borra las variables de la lista (dadas mediante nombre o número) del conjunto de datos. <@itl="Debe usarse con precaución">: no se pide confirmación, y cualquier variable con número de ID mayor será renumerada. 

Si con esta instrucción no se proporciona una lista <@var="listavar">, se borra la última variable (la de número ID mayor) del conjunto de datos. 

Menú gráfico: Menú emergente de la ventana principal (selección simple)

# diff Transformations

Argumento: 	<@var="listavar"> 

Se obtiene la primera diferencia de cada variable de la lista <@var="listavar"> y el resultado se guarda en una nueva variable cuyo nombre tiene el prefijo <@lit="d_">. Así <@lit="diff x y"> crea las nuevas variables <@lit="d_x = x(t) - x(t-1)"> y <@lit="d_y = y(t) - y(t-1)">. 

Menú gráfico: /Datos/Añadir variables/Primeras diferencias

# else Programming

Ver <@ref="if">. 

# end Programming

Cierra un bloque de instrucciones de algunos tipos. Por ejemplo, <@lit="end system"> termina un sistema de ecuaciones (Ver <@ref="system">). 

# endif Programming

Ver <@ref="if">. 

# endloop Programming

Marca el final de un bucle de instrucciones. Ver <@ref="loop">. 

# eqnprint Printing

Argumento: 	[ <@var="-f nombre_de_fichero"> ] 
Opción: 	<@lit="--complete"> (Crea un documento completo)

Debe ejecutarse después de la estimación de un modelo. Presenta el modelo estimado en formato de ecuación LaTeX. Si se especifica un nombre de fichero usando la opción <@lit="-f"> la salida va a ese fichero, en caso contrario va a una fichero cuyo nombre tiene la forma <@lit="equation_N.tex">, donde <@lit="N"> es el número de modelos estimados hasta el momento en la sesión actual. Ver también <@ref="tabprint">. 

Si se aplica la opción <@lit="--complete">, el fichero LaTeX es un documento completo, listo para ser procesado; en caso contrario deberá incluirse dentro de un documento previamente preparado. 

Menú gráfico: Ventana de Modelo, /LaTeX

# equation Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Ejemplo: 	<@lit="equation y x1 x2 x3 const">

Sirve pare especificar una ecuación dentro de un sistema de ecuaciones (ver <@ref="system">). La sintaxis para especificar una ecuación dentro de un sistema SUR (Ecuaciones de regresión aparentemente no relacinadas) es la misma que, por ejemplo, la de MCO (ver <@ref="ols">). Para una ecuación dentro de un sistema de Mínimos Cuadrados en Tres Etapas se puede (a) dar la especificación de una ecuación de tipo MCO y proporcionar una lista común de instrumentos usando la opción <@lit="instr"> (ver de nuevo <@ref="system">), o (b) usar la misma sintaxis de definición de ecuaciones que para <@ref="tsls">. 

# fcast Prediction

Argumentos: 	[ <@var="obs_inic obs_fin"> ] <@var="var_ajustada"> 
Ejemplos: 	<@lit="fcast 1997:1 2001:4 f1">
		<@lit="fcast fit2">

Debe ejecutarse después de una instrucción de estimación. Se generan predicciones para el dominio muestral especificado (o el dominio muestral mayor posible si no se han proporcionado <@var="obs_inic"> y <@var="obs_fin">) y los valores se guardan como <@var="var_ajustada">, que luego puede mostrarse o representarse gráficamente. Las variables del lado derecho son las del modelo original. No se pueden sustituir por otras variables. Si se especifica un proceso de error autorregresivo (para <@lit="hilu">, <@lit="corc">, y <@lit="ar">) la predicción se hace condicionada un paso adelante y tiene en cuenta el proceso del error. 

Menú gráfico: Ventana de Modelo, /Datos del Modelo/Predicciones con desviaciones típicas

# fcasterr Prediction

Argumentos: 	<@var="obs_inic"> <@var="obs_fin"> 

Después de estimar un modelo por medio de MCO usted puede usar esta instrucción para mostrar los valores ajustados para el rango de observaciones determinado, las desviaciones típicas de estos valores ajustados y los intervalos de confianza del 95 por ciento. 

Las desviaciones típicas se calculan de la forma descrita en el Capítulo 6 del libro de Wooldridge <@itl="Introductory Econometrics">. Estas tienen en cuenta dos fuentes de variabilidad: la asociada al valor esperado de la variable dependiente condicionado a los valores dados de las variables independientes, y la varianza de los residuos de la regresión. 

Menú gráfico: Ventana de Modelo, /Datos del modelo/Predicciones con desviaciones típicas

# freq Statistics

Argumento: 	<@var="var"> 

Presenta la distribución de frecuencias de la variable <@var="var"> (que se da por nombre o número); también muestra los resultados del contraste de normalidad de Doornik–Hansen. En modo interactivo, se presenta un gráfico de la distribución. 

Menú gráfico: /Variable/Distribución de frecuencias

# function Programming

Define una función. 

# garch Estimation

Argumentos: 	<@var="p"> <@var="q"> ; <@var="vardep"> [ <@var="varindeps"> ] 
Opciones: 	<@lit="--robust"> (Desviaciones típicas robustas)
		<@lit="--verbose"> (muestra los detalles de las iteraciones)
		<@lit="--vcv"> (presenta la matriz de covarianzas)
Ejemplos: 	<@lit="garch 1 1 ; y">
		<@lit="garch 1 1 ; y 0 x1 x2 --robust">

Estima un modelo GARCH (GARCH = Generalized Autoregressive Conditional Heteroskedasticity), o un modelo univariante o, si se especifican <@var="varindeps">, un modelo que incluye las variables exógenas dadas. Los valoires enteros <@var="p"> y <@var="q"> representan los órdenes de retardos en la ecuación de la varianza condicional. 

  <@fig="garch_h">

El algoritmo GARCH de gretl es básicamente el de Fiorentini, Calzolari y Panattoni (1996), y se usa con el amable permiso del profesor Fiorentini. 

Con esta instrucción están disponibles varias variantes de las estimaciones de la matriz de covarianzas de los coeficientes. Por defecto se usa el Hessiano a no ser que se indique la opción <@lit="--robust">, en cuyo caso se utiliza la matriz de covarianzas QML (White). Se pueden especificar otras posibilidades (p.ej. la matriz de información, o el estimador Bollerslev–Wooldridge) usando la instrucción <@ref="set">. 

Menú gráfico: /Modelo/Serie temporal/GARCH

# genr Dataset

Argumentos: 	<@var="nueva_var"> <@var="= fórmula"> 

Crea variables nuevas, normalmente como transformaciones de variables ya existentes. Ver también <@ref="diff">, <@ref="logs">, <@ref="lags">, <@ref="ldiff"> y <@ref="square"> como atajos. 

Los <@itl="operadores aritméticos"> soportados son, en orden de precedencia: <@lit="^"> (exponenciación); <@lit="*">, <@lit="/"> y <@lit="%"> (módulo o resto); <@lit="+"> y <@lit="-">. 

Los <@itl="operadores Booleanos"> disponibles son (de nuevo, en orden de precedencia): <@lit="!"> (negación), <@lit="&&"> (Y lógico), <@lit="||"> (O lógico), <@lit=">">, <@lit="<">, <@lit="=">, <@lit=">="> (mayor o igual que), <@lit="<="> (menor o igual que) y <@lit="!="> (distinto que). Se pueden usar operadores Booleanos para construir variables ficticias: por ejemplo <@lit="(x > 10)"> devuelve 1 si <@lit="x"> > 10, y 0 en otro caso. 

Las <@itl="funciones"> se clasifican en: 

<indent>
• Funcione matemáticas estándar: <@lit="abs">, <@lit="cos">, <@lit="exp">, <@lit="int"> (parte entera), <@lit="ln"> (logaritmo natural: <@lit="log"> es un sinónimo), <@lit="sin">, <@lit="sqrt">. 
</indent>

<indent>
• Funciones estadísticas: <@lit="max"> (valor máximo de una serie), <@lit="min"> (mínimo), <@lit="mean"> (media aritmética), <@lit="median">, <@lit="var"> (varianza) <@lit="sd"> (desviación típica), <@lit="sst"> (suma de desviaciones desde la media, al cuadrado), <@lit="sum">, <@lit="cov"> (covarianza), <@lit="corr"> (coeficiente de correlación), <@lit="pvalue">, <@lit="sort">, <@lit="cum"> (acumulación, o suma secuencial), <@lit="resample"> (remuestrear una serie con reemplazamiento, con el propósito de hacer bootstrap), <@lit="hpfilt"> (Filtro de Hodrick–Prescott: esta función devuelve el "componente cíclico" de la serie). 
</indent>

<indent>
• Funciones de series temporales: <@lit="diff"> (primera diferencia), <@lit="ldiff"> (diferencia logarítmica, o primera diferencia del logaritmo natural). Para generar retardos de una variable <@lit="x">, se usa la sintaxis <@lit="x(-N)">, donde <@lit="N"> representa la longitud deseada del retardo; para generar adelantos, se usa <@lit="x(+N)">. 
</indent>

<indent>
• Funciones de conjunto de datos: <@lit="misszero"> (reemplaza los códigos de observación ausente de una serie dada con ceros); <@lit="zeromiss"> (la operación inversa a <@lit="misszero">); <@lit="nobs"> (devuelve el número de observaciones válidas de una serie de datos determinada), <@lit="missing"> (para cada observación, devuelve 1 si el argumento tiene una observación ausente, y 0 en caso contrario); <@lit="ok"> (el opuesto de <@lit="missing">). 
</indent>

<indent>
• Números pseudo-aleatorios: <@lit="uniform">, <@lit="normal">. 
</indent>

Todas las funciones de arriba excepto <@lit="cov">, <@lit="corr">, <@lit="pvalue">, <@lit="uniform"> y <@lit="normal"> toman como único argumento o el nombre de una variable (nótese que, en una fórmula <@lit="genr">, no es posible referirse a las variables por su número de ID) o una expresión que se evalúa en una variable (p.ej. <@lit="ln((x1+x2)/2)">). <@lit="cov"> y <@lit="corr"> requieren dos argumentos, y devuelven respectivamente la covarianza y el coeficiente de correlación entre sus argumentos. La función <@lit="pvalue"> toma los mismos argumentos que la instrucción <@ref="pvalue">, pero en este contexto deben introducirse comas entre los argumentos. Esta función devuelve un valor p a una cola y, en el caso de las distribuciones normal y <@itl="t">, es para la "cola corta". Con la normal, por ejemplo, tanto 1,96 como -1,96 darán un resultado de aproximadamente 0,025. 

<@lit="uniform()"> y <@lit="normal()">, que no toman arguamentos, devuelven series de números pseudo-aleatorios extraídos de la distribución uniforme (0–1) y normal estándar respectivamente (ver también la instrucción <@ref="set">, opción <@lit="seed">). La series de datos uniformes se generan utilizando el Mersenne Twister; para series normales se usa el método de Box y Muller (1958), tomando la entrada del Mersenne Twister. 

Además de los operadores y funciones ya mencionados, hay algunos usos especiales de <@lit="genr">: 

<indent>
• <@lit="genr time"> crea una variable de tendencia temporal (1,2,3,…) llamada <@lit="time">. <@lit="genr index"> hace lo mismo, excepto que ahora la variable se denomina <@lit="index">. 
</indent>

<indent>
• <@lit="genr dummy"> crea variables ficticias hasta la periodicidad de los datos. P.ej. en el caso de datos trimestrales (periodicidad 4), el programa crea <@lit="dummy_1"> = 1 para el primer trimestre y 0 en los demás trimestres, <@lit="dummy_2"> = 1 para el segundo trimestre y 0 en los demás, y así sucesivamente. 
</indent>

<indent>
• <@lit="genr paneldum"> crea un conjunto de variables ficticias especiales para ser usadas con un conjunto de datos de panel — ver <@ref="panel">. 
</indent>

Usando <@lit="genr"> se pueden recuperar los valores de algunas variables internas que se definen al ejecutar una regresión, de la siguiente foprma: 

<indent>
• <@lit="$ess">: suma de cuadrados de los residuos 
</indent>

<indent>
• <@lit="$rsq">: <@itl="R">-cuadrado no corregido 
</indent>

<indent>
• <@lit="$T">: número de observaciones usadas 
</indent>

<indent>
• <@lit="$df">: grados de libertad 
</indent>

<indent>
• <@lit="$trsq">: <@itl="TR">-cuadrado (el tamaño muestral por el <@itl="R">-cuadrado) 
</indent>

<indent>
• <@lit="$sigma">: desviación típica de los residuos 
</indent>

<indent>
• <@lit="$aic">: Criterio de información de Akaike 
</indent>

<indent>
• <@lit="$bic">: Criterio de información de Schwarz 
</indent>

<indent>
• <@lit="$lnl">: logaritmo de la verosimilitud (donde es aplicable) 
</indent>

<indent>
• <@lit="coeff">(<@var="var">): coeficiente estimado para la variable <@var="var"> 
</indent>

<indent>
• <@lit="stderr">(<@var="var">): desviación típica estimada para la variable <@var="var"> 
</indent>

<indent>
• <@lit="rho">(<@var="i">): coeficiente autorregresivo de <@var="i">-ésimo orden de los residuos 
</indent>

<indent>
• <@lit="vcv">(<@var="x1">,<@var="x2">): covarianza entre los coeficientes para las variables nombradas <@var="x1"> y <@var="x2"> 
</indent>

<@itl="Nota">: En el programa en línea de instrucciones, las instrucciones <@lit="genr"> que recuperan datos relativos a un modelo siempre hacen referencia al último modelo estimado. Esto también es cierto para el programa en modo GUI, si uno usa <@lit="genr"> en la "consola de gretl" o introduce una fórmula usando la opción "Definir nueva variable" del menú de Variable en la ventana principal. Sin embargo, con el GUI, usted tiene la posibilidad de recuperar datos de cualquier modelo que actualmente se esté mostrando en una ventana (sea o no el modelo más reciente). Usted puede hacer esto bajo el menú "Datos del Modelo" de la ventana del modelo. 

Las series internas <@lit="uhat"> e <@lit="yhat"> contienen, respectivamente, los residuos y los valores ajustados de la última regresión. 

También están disponibles dos variables "internas" relacionadas con el conjunto de datos actual: <@lit="$nobs"> contiene el número de observaciones del rango muestral actual (que puede ser o no igual a <@lit="$T">, el número de observaciones usadas al estimar el último modelo), y <@lit="$pd"> contiene la frecuencia o periodicidad de los datos (p.ej 4 para datos trimestrales). 

La variable <@lit="t"> sirve como índice de las observaciones. Por ejemplo <@lit="genr dum = (t=15)"> generará una variable ficticia que toma valor 1 para la observación 15, y 0 en las demás. La variable <@lit="obs"> es similar pero más flexible: usted puede usarla para extraer observaciones particulares por fecha o nombre. Por ejemplo, <@lit="genr d = (obs>1986:4)"> o <@lit="genr d = (obs="CA")">. La última forma presupone que las observaciones tienen etiquetas; la etiqueta debe ponerse entre comillas. 

Pueden utilizarse valores escalares de una serie en el contexto de una fórmula <@lit="genr">, usando la sintaxis <@var="nombre_var"><@lit="["><@var="obs"><@lit="]">. El valor <@var="obs"> puede darse por número o fecha. Ejemplos: <@lit="x[5]">, <@lit="CPI[1996:01]">. Para datos diarios data, se debe de usar la forma <@var="YYYY:MM:DD">, p.ej. <@lit="ibm[1970:01:23]">. 

Se puede modificar una observación individual de una serie por medio de <@lit="genr">. Para hacerlo, hay que adjuntar al nombre de la variable en el lado izquierdo de la fórmula, entre corchetes, un número de observación válido o una fecha. Por ejemplo, <@lit="genr x[3] = 30"> o <@lit="genr x[1950:04] = 303.7">. 

Aquí hay un par de sugerencias sobre variable ficticias: 

<indent>
Supongamos que <@lit="x"> está codificada con los valores 1, 2, o 3 y usted quiere tres variables ficticias, <@lit="d1"> = 1 si <@lit="x"> = 1, 0 en otro caso, <@lit="d2"> = 1 si <@lit="x"> = 2, y así sucesivamente. Para crearlas, use las instrucciones: 
</indent>

<code>          
	    genr d1 = (x=1)
	    genr d2 = (x=2)
	    genr d3 = (x=3)
</code>

<indent>
Para crear <@lit="z"> = <@lit="max(x,y)"> do 
</indent>

<code>          
	    genr d = x>y
	    genr z = (x*d)+(y*(1-d))
</code>

Menú gráfico: /Variable/Definir nueva variable
Otro acceso: Menú emergente de la ventana principal

# gnuplot Graphs

Argumentos: 	<@var="yvars"> <@var="xvar"> [ <@var="dumvar"> ] 
Opciones: 	<@lit="--with-lines"> (usar líneas, no puntos)
		<@lit="--with-impulses"> (usar líneas verticales)
		<@lit="--suppress-fitted"> (no mostrar el ajuste mínimo-cuadrático)
		<@lit="--dummy"> (ver abajo)
Ejemplos: 	<@lit="gnuplot y1 y2 x">
		<@lit="gnuplot x time --with-lines">
		<@lit="gnuplot wages educ gender --dummy">

Sin la opción <@lit="--dummy">, las variables <@var="yvars"> se representan contra <@var="xvar">. Con <@lit="--dummy">, <@var="yvar"> se representa contra <@var="xvar"> con los puntos pintados de diferentes colores dependiendo de si el valor de <@var="dumvar"> es 1 o 0. 

La variable <@lit="time"> se comporta de manera especial: si no existe, entonces se generará automáticamente. 

En modo interactivo los resultados se muestran inmediatamente. En modo batch se escribe un fichero de instrucciones gnuplot con un nombre que sigue el modelo <@lit="gpttmpN.plt">, empezando con N = <@lit="01">. Los gráficos actuales se pueden generar más tarde usando gnuplot (bajo MS Windows, wgnuplot). 

Hay una nueva opción disponible en esta instrucción: después de la especificación de las variables a representar y las opciones (si se elige alguna), usted puede añadir instrucciones literales de gnuplot para controlar la apariencia del gráfico (por ejemplo, poner el título del gráfico y/o el rango de los ejes). Estas instrucciones deberían incluírse entre paréntesis y cada instrucción gnuplot debe terminar con un punto y coma. Se puede usar una barra invertida (/) para continuar un conjunto de instrucciones gnuplot sobre más de una línea. He aquí un ejemplo de la sintaxis: 

<@lit="{ set title 'Mi título'; set yrange [0:1000]; }"> 

Menú gráfico: /Datos/Gráficos
Otro acceso: Menúe emergente de la ventana principal, botón de gráfico de
      la barra de herramientas

# graph Graphs

Argumentos: 	<@var="yvars"> <@var="xvar"> 
Opción: 	<@lit="--tall"> (usar 40 filas)

Gráficos ASCII. Las variables <@var="yvars"> (que pueden determinarse por nombre o número) se representan con respecto a <@var="xvar"> usando símbolos ASCII. La opción <@lit="--tall"> producirá un gráfico con 40 filas y 60 columnas. Sin ella, el gráfico será de 20 por 60 (para salida por pantalla). Ver también <@ref="gnuplot">. 

# hausman Tests

Este contraste sólo está disponible después de haber estimado un modelo mediante la instrucción <@ref="ols"> (ver también <@lit="panel"> y <@lit="setobs">). Contrasta el modelo simple combinado contra sus alternativas principales, el modelo de efectos fijos y el modelo de efectos aleatorios. 

El modelo de efectos fijos añade una variable ficticia para todas menos una de las unidades de sección cruzada, permitiendo al intercepto de la regresión variar a través de estas unidades. Se presenta un estadístico <@itl="F"> para el contraste de significación conjunta de estas variables ficticias. El modelo de efectos aleatorios descompone la varianza residual en dos partes, una parte específica de las unidades de sección cruzada y la otra específica de cada observación particular. (Este estimador sólo puede computarse si el número de unidades de sección cruzada es mayor que el número de parámetros a estimar.) El estadístico LM de Breusch–Pagan sirve para contrastar la hipótesis nula (de que el estimador MCO combinado es el adecuado) contra la alternativa de efectos aleatorios. 

El modelo de MCO combinados puede ser rechazado contra ambas alternativas, el modelo de efectos fijos y el de efectos aleatorios. Si el error específico de unidad o grupo está incorrelacionado con las variables independientes, el estimador de efectos aleatorios es más eficiente que el estimador de efectos fijos; en caso contrario el estimador de efectos aleatorios sería inconsistente y sería preferible el estimador de efectos fijos. La hipótesis nula para el contraste de Hausman es que el error específico de grupo no está tan correlacionado (así que es preferible el modelo de efectos aleatorios). Un valor p bajo para este contraste es un síntoma en contra del modelo de efectos aleatorios y a favor del modelo de efectos fijos. 

Menú gráfico: Ventana de Modelo, /Contrastes/Diagnósticos de panel

# hccm Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (presenta la matriz de covarianzas)

Matriz de covarianzas consistente ante heterocedasticidad: esta instrucción ejecuta una regresión en la que los coeficientes se estiman mediante un procedimiento MCO estándar, pero las desviaciones típicas de los coeficientes estimados se calculan de una manera que es robusta ante heterocedasticidad, en concreto usando el procedimiento "jackknife" de MacKinnon–White. 

Menú gráfico: /Modelo/HCCM

# help Utilities

Proporciona una lista de las instrucciones disponibles. <@lit="help"> <@var="instrucción"> describe la <@var="instrucción"> (p.ej. <@lit="help smpl">). Vd. puede escribir <@lit="man"> en lugar de <@lit="help"> si lo desea. 

Menú gráfico: /Ayuda

# hilu Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (presenta la matriz de covarianzas)

Calcula estimaciones de los parámetros del modelo especificado usando el procedimiento de búsqueda de Hildreth–Lu search procedure (refinado mediante el procedimiento CORC). Este procedimiento está diseñado para corregir las estimaciones teniendo en cuenta la correlación serial del término de error. La suma de cuadrados de los residuos del modelo transformado se representa con respecto al valor de rho desde –0.99 hasta 0.99. 

Menú gráfico: /Modelo/Serie temporal/Hildreth-Lu

# hsk Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (presenta la matriz de covarianzas)

Se calcula una regresión por MCO y se guardan los residuos. El logaritmo del cuadrado de los residuos entonces pasa a ser la variable dependiente en una regresión auxiliar, en cuyo lado derecho están las variables independientes originales más sus cuadrados. Los valores ajustados en la regresión auxiliar se usan entonces para construir una serie de ponderaciones y el modelo original se reestima utilizando mínimos cuadrados ponderados. El resultado final se presenta en un informe. 

La serie de ponderaciones se forma como <@fig="hsk">, donde <@itl="y<@sup="*">"> denota los valores ajustados mediante la regresión auxiliar. 

Menú gráfico: /Modelo/Corregido de Heterocedasticidad

# if Programming

Control de flujo para la ejecución de instrucciones. La sintaxis es: 

	<@lit="if"> <@var="condición">
	<@lit="  "> <@var="instrucciones1">
	<@lit="else">
	<@lit="  "> <@var="instrucciones2">
	<@lit="endif">

<@var="condición"> debe ser una expresión Booleana, para su sintaxis ver <@ref="genr">. El bloque <@lit="else"> es opcional; los bloques <@lit="if"> … <@lit="endif"> pueden estar anidados. 

# info Dataset

Presenta cualquier información suplemnentaria que se haya guardado con el fichero de datos actual. 

Menú gráfico: /Datos/Leer información
Otro acceso: Ventanas de navegación de datos

# setinfo Dataset

Argumentos: 	<@var="nombre_var"> <@lit="-d "><@var="descripción"> <@lit="-n "><@var="nombre a mostrar"> 
Ejemplo: 	<@lit="label x1 -d "Descripción de x1" -n "Nombre en los gráficos"">

Establece la etiqueta descriptiva de la variable determinada (si se da la opción <@lit="-d">, seguida de una cadena de caracteres entre comillas) y/o el "nombre a mostrar" para la variable (si se da la opción <@lit="-n">, seguida de una cadena de caracteres entre comillas). Si una variable tiene un "nombre a mostrar", se usará éste al generar los gráficos. 

Menú gráfico: /Variable/Editar atributos
Otro acceso: Menú emergente de la ventana principal

# labels Dataset

Presenta las etiquetas informativas de cualquier variable que haya sido generada usando la instrucción <@lit="genr">, y cualquier variable añadida al conjunto de datos por medio del GUI. 

# lad Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 

Calcula una regresión que minimiza la suma de las desviaciones absolutas de los valores observados de la variable dependiente con respecto a los ajustados. La estimaciones de los coeficientes se derivan usando el algoritmo simplex de Barrodale–Roberts; se muestra un aviso si la solución no es única. Las desviaciones típicas se derivan utilizando el procedimiento bootstrap con 500 extracciones. 

Menú gráfico: /Modelo/Mínima devsiación absoluta

# lags Transformations

Argumento: 	<@var="listavar"> 

Crea variables nuevas que son valores retardados de cada una de las variables de <@var="listavar">. El número de variables retardadas es igual a la periodicidad. Por ejemplo, si la periodicidad es 4 (trimestral), la instrucción <@lit="lags x y"> crea <@lit="x_1"> = <@lit="x(t-1)">, <@lit="x_2"> = <@lit="x(t-2)">, <@lit="x_3"> = <@lit="x(t-3)"> y <@lit="x_4"> = <@lit="x(t-4)">. Lo mismo para <@lit="y">. Estas variables deben ser referenciadas de manera exacta, es decir, con el carácter de subrayado. 

Menú gráfico: /Datos/Añadir variables/retardos de las variables seleccionadas

# ldiff Transformations

Argumento: 	<@var="listavar"> 

Calcula la primera diferencia del logaritmo natural de cada variable de <@var="listavar"> y guarda el resultado en una nueva variable con el prefijo <@lit="ld_">. Así <@lit="ldiff x y"> crea las nuevas variables <@lit="ld_x"> = <@fig="ldx"> y <@lit="ld_y"> = <@fig="ldy">. 

Menú gráfico: /Datos/Añadir variables/diferencias de logaritmos de las variables seleccionadas

# leverage Tests

Opción: 	<@lit="--save"> (guardar las variables)

Debe ejecutarse inmediatamente después de una instrucción <@lit="MCO">. Calcula el apalancamiento (<@itl="h">, que debe estar entre 0 y 1) para cada punto de datos de la muestra sobre la que se estimó el último modelo. Presenta el residuo (<@itl="u">) de cada observación junto a su apalancamiento y una medida de su influencia sobre las estimaciones, <@fig="influence">. Los "puntos palanca" para los cuales el valor de <@itl="h"> es mayor que 2<@itl="k">/<@itl="n"> (donde <@itl="k"> es el número de parámetros estimados y <@itl="n"> es el tamaño muestral) se marcan con un asterisco. Para más detalles sobre los conceptos de apalancamiento e influencia ver Davidson and MacKinnon (1993, Capítulo 2). 

También se presentan los valores DFFITS: estos son los "residuos studentizados" (residuos predichos divididos por sus desviaciones típicas) multiplicados por <@fig="dffit">. Para más detalles sobre residuos studentizados y DFFITS ver el libro de G. S. Maddala, <@itl="Introduction to Econometrics">, capítulo 12; y también Belsley, Kuh y Welsch (1980). En resumen, un "residuo predicho" es la diferencia entre el valor observado de la variable dependiente en la observación <@itl="t"> y el valor ajustado para la observación <@itl="t"> obtenido de una regresión en la que se omite esa observación (o se añade una variable ficticia con valor 1 sólo para la observación <@itl="t">); el residuo studentizado se obtiene dividiendo el residuo predicho por su desviación típica. 

Si con esta instrucción se da la opción <@lit="--save">, entonces los valores del apalancamiento, influencia y DFFITS se añaden al conjunto de datos actual. 

Menú gráfico: Ventana de Modelo, /Contrastes/observaciones influyentes

# lmtest Tests

Opciones: 	<@lit="--logs"> (no linealidad, logaritmos)
		<@lit="--autocorr"> (correlación serial)
		<@lit="--squares"> (no linealidad, cuadrados)
		<@lit="--white"> (heterocedasticidad (Contraste de White))

Debe ejecutarse justo después de una instrucción <@lit="mco">. Realiza alguna combinación de lo siguiente: contrastes de Multiplicador de Lagrange de no linealidad (logaritmos y cuadrados), contraste de heterocedasticidad de White, y el contraste LMF de correlación serial hasta el orden de la periodicidad (ver Kiviet, 1986). También se presentan los correspondientes coeficientes de la regresión auxiliar. Ver Ramanathan, Capítulos 7, 8, y 9 para más detalles. En el,caso del contrastes de White, sólo se usan los cuadrados de las variables independientes y no sus productos cruzados. En el caso del contraste de autocorrelación, si el valor p del estadístico LMF es menor que 0,05 (y el modelo no se había estimado originariamente con desviaciones típicas robustas) entonces se calculan y se presentan las desviaciones típicas robustas ante correlación serial. Para detalles sobre el cálculo de estas desviaciones típicas ver Wooldridge (2002, Capítulo 12). 

Menú gráfico: Ventan de Modelo, /Contrastes

# logistic Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> [ <@lit="ymax="><@var="valor"> ] 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
Ejemplos: 	<@lit="logistic y const x">
		<@lit="logistic y const x ymax=50">

Regresión logística: desarrolla una regresión MCO utilizando la transformación logística de la variable dependiente, 

  <@fig="logistic1">

La variable dependiente debe ser estrictamente positiva. Si es una fracción decimal, entre 0 y 1, por defecto se usa un valor <@itl="y"><@sup="*"> (el máximo asintótico de la variable dependiente) of 1. Si la variable dependiente es un porcentaje, entre 0 y 100, por defecto <@itl="y"><@sup="*"> es 100. Si Vd. desea establecer otro valor máximo utilice el parámetro opcional <@lit="ymax="><@var="valor"> después de la lista de regresores. El valor proporcionado debe ser mayor que todos los valores observados de la variable dependiente. 

Los valores ajustados y los residuos de la regresión se transforman automáticamente usando 

  <@fig="logistic2">

donde <@itl="x"> representa o un valor ajustado o un residuo de la regresión MCO usando la variable dependiente transformada. Los valores que se presentan son así comparables con los valores originales de la variable dependiente. 

Nótese que si la variable dependiente es binaria, en lugar de esto se debería usar la instrucción <@lit="logit">. 

Menú gráfico: /Modelo/Logístico

# logit Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)

Regresión binomial logit. La variable dependiente debería ser una variable binaria. Se obtienen las estimaciones máximo-verosímiles de los coeficientes de las variables <@var="varindeps"> por medio del método EM (Expectation–Maximization method, ver Ruud, 2000, Capítulo 27). Como el modelo no es lineal las pendientes dependen de los valores de las variables independientes: las poendientes que se presentan se han evaluado en la media de dichas variables. La hipótesis de que todos los coeficientes, aparte de la constante, son cero se contrasta mediante el estadístico chi-cuadrado. 

Si Vd. desea utilizar logit para el análisis de proporciones (donde la variable dependiente, para cada observación, es la proporción de casos que tienen una determinada característica, en lugar de un 1 o un 0 indicando si la característica está presente o no) no debería usar la instrucción <@lit="logit">, sino mejor debería construir la variable logit (p.ej. <@lit="genr lgt_p = log(p/(1 - p))">) y usarla como variable dependiente en una regresión MCO. Ver Ramanathan, Capítulo 12. 

Menú gráfico: /Modelo/Logit

# logs Transformations

Argumento: 	<@var="listavar"> 

Se obtiene el logaritmo natural de cada una de las variables de <@var="listavar"> y el resultado se guarda en una nueva variable con el prefijo <@lit="l_"> que es "ele" y carácter de subrayadoe. <@lit="logs x y"> crea las nuevas variables <@lit="l_x"> = ln(<@lit="x">) y <@lit="l_y"> = ln(<@lit="y">). 

Menú gráfico: /Datos/Añadir variables/logaritmos de las variables seleccionadas

# loop Programming

Argumento: 	<@var="control"> 
Opción: 	<@lit="--progressive"> (permite formas especiales de ciertas instrucciones)
Ejemplos: 	<@lit="loop 1000">
		<@lit="loop 1000 --progressive">
		<@lit="loop while essdiff > .00001">
		<@lit="loop for i=1991..2000">
		<@lit="loop for (r=-.99; r<=.99; r+=.01)">

El parámetro <@var="control"> debe tomar una de las cuatro formas posibles, tal y como se muestra en los ejemplos: un número de veces entero a repetir las instrucciones del bucle; "<@lit="while">" más una condición numérica; o "<@lit="for">" más un rango de valores para la variable índice interna <@lit="i">; o "<@lit="for">" más tres expresiones entre paréntesis, separadas por puntos y comas. En la última forma, la expresión del lado izquierdo inicializa una variable, la del medio establece una condición para que continúen las iteraciones, y la de la derecha determina un incremento o decremento a aplicar al comienzo de la segunda y siguientes iteraciones. (Esta es una forma restringida de la instrucción <@lit="for"> del lenguaje de programación C.) 

Esta instrucción abre un modo de ejecución especial en el cual el programa acepta instrucciones a ejecutar repetidamente. Dentro de un bucle sólo se pueden utilizar ciertas instrucciones: <@lit="genr">, <@lit="ols">, <@lit="print">, <@lit="printf">, <@lit="pvalue">, <@lit="sim">, <@lit="smpl">, <@lit="store">, <@lit="summary">, <@lit="if">, <@lit="else"> y <@lit="endif">. Se sale del modo de introducción de instrucciones de bucle con <@lit="endloop">: en este punto se ejecutan todas las instrucciones que están en la cola del bucle. 

Ver <@pdf="el manual de gretl"> para más detalles y ejemplos. El efecto de la opción <@lit="--progressive"> (que está diseñada para su uso en simulaciones de Monte Carlo) se explica allí. 

# meantest Tests

Argumentos: 	<@var="var1"> <@var="var2"> 
Opción: 	<@lit="--unequal-vars"> (suponer que las varianzas son diferentes)

Calcula el estadístico <@itl="t"> para la hipótesis nula de que las medias poblacionales de las variables <@var="var1"> y <@var="var2"> son iguales, y presenta su valor p. Por defecto se calcula el estadístico bajo el supuesto de que las varianzas de las dos variables son iguales; con la opción <@lit="--unequal-vars"> se suponen varianzas distintas. Esto implicará una diferencia en el estadístico de contraste sólo si hay un número diferente de valores no ausentes para las dos variables. 

Menú gráfico: /Datos/Diferencia de medias

# modeltab Utilities

Argumentos: 	<@var="add"> o <@var="show"> o <@var="free"> 

Sirve para manipular la "tabla de modelos" de gretl. Ver <@pdf="el manual de gretl"> para más detalles. Las sub-instrucciones tienen los isguientes efectos: <@lit="add"> añade el último modelo estimado a la tabla de modelos, si es posible; <@lit="show"> presenta la tabla de modelos en una ventana; y <@lit="free"> vacía la tabla. 

Menú gráfico: Ventana de sesión, icono de Tabla de modelos

# mpols Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 

Computa las estimaciones MCO para el modelo especificado, usando aritmética de punto flotante con precisión múltiple. Esta instrucción sólo está disponible si gretl se compila con soporte para la biblioteca Gnu de Precisión Múltiple (GMP). 

Para estimar un ajuste polinomial usando aritmética de precisión múltiple para generar las potencias necesarias de la variable independiente use por ejmplo la forma <@lit="mpols y 0 x ; 2 3 4">. Esto realiza una regresión de <@lit="y"> sobre <@lit="x">, <@lit="x"> cuadrado, <@lit="x"> al cubo y <@lit="x"> a la cuarta potencia. Es decir, los números a la derecha del punto y coma (que deben ser enteros positivos) determinan las potencias de <@lit="x"> a utilizar. Si se especifica más de una variable independiente, ha de considerarse que la última antes del punto y coma es la variable que va a ser elevada a varias potencias. 

Menú gráfico: /Modelo/MCO de alta precisión

# nls Estimation

Argumentos: 	<@var="función"> <@var="derivadas"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)

Desarrolla la estimación por Mínimos Cuadrados No Lineales (NLS) utilizando una versión modificada del algoritmo de Levenberg-Marquardt. El usuario debe suministrar la especificación de una función. Los parámetros de esta función deben ser declarados antes y hay que asignarles unos valores iniciales (usando la instrucción <@lit="genr">) antes de la estimación. Opcionalmente, el usuario puede especoficar las derivadas de la función de regresión con respectyo a cada uno de los parámetros; si nbo se proporcionan las derivadas analíticas se computa una aproximación numérica al Jacobiano. 

Es más sencillo mostrar lo que se necesita con un ejemplo. Lo siguiente es un lote de instrucciones completo para estimar la función de consumo no lineal definida en el libro de William Greene <@itl="Econometric Analysis"> (Capítulo 11 de la 4ª edición inglesa, o Capítulo 9 de la 5ª). Los números a la izquierda de las líneas son para referencia y no son parte de las instrucciones. Hay que señalar que la opción <@lit="--vcv">, para presentar la matriz de covarianzas de las estimaciones de los parámetros se escribe junto a la instrucción final, <@lit="end nls">. 

<code>          
	1   open greene11_3.gdt
	2   ols C 0 Y
	3   genr alfa = coeff(0)
	4   genr beta = coeff(Y)
	5   genr gamma = 1.0
	6   nls C = alfa + beta * Y^gamma
	7   deriv alfa = 1
	8   deriv beta = Y^gamma
	9   deriv gamma = beta * Y^gamma * log(Y)
	10  end nls --vcv
</code>

Muchas veces es conveniente inicializar los parámetros haciendo referencia a un modelo lineal relacionado con el actual; esto se realiza aquí en las líneas 2 a 5. A los parámetros alfa, beta y gamma se les podría asignar cualesquiera valores iniciales (no necesariamente basados en un modelo estimado por MCO), aunque la convergencia del procedimiento de MC no lineales no está garantizada para un punto de inicio arbitrario. 

Las instrucciones de MC no lineales actuales ocupan las líneas 6 a 10. En la línea 6 se invoica la instrucción <@lit="nls">: se especifica una variable dependiente seguida de un signo igual y después la especificación de una función. La sintaxis para la expresión de la derecha es la misma que para la instrucción <@lit="genr">. Las tres siguientes líneas determinan las derivadas de la función de regresión con respecto a cada uno de los parámetros. Cada línea comienza con la palabra <@lit="deriv">, da el nombre de un parámetro, un signo igual y una expresión por la que se calcula la derivada (de nuevo, la sintaxis aquí es la misma que para <@lit="genr">). Estas líneas <@lit="deriv"> son opcionales, pero es conveniente proporcionarlas, si es posible. La línea 10, <@lit="end nls">, completa la instrucción e invoca la estimación. 

Para más detalles sobre la estimación por MC. no lineales ver <@pdf="el manual de gretl">. 

Menú gráfico: /Modelo/Mínimos cuadrados no lineales

# nulldata Dataset

Argumento: 	<@var="largura de la serie"> 
Ejemplo: 	<@lit="nulldata 500">

Forma un conjunto de datos "vacío", que contiene sólo una constante y una variable índice, con periodicidad 1 y el número de observaciones especificado. Esto puede usarse para hacer simulaciones: algunas de las instrucciones <@lit="genr"> (p.ej. <@lit="genr uniform()">, <@lit="genr normal()">) generan, desde cero, datos ficticios para rellenar el conjunto de datos. Esta instrucción puede ser útil también junto a la instrucción <@lit="loop">. Ver también la opción "seed" de la instrucción <@ref="set">. 

Menú gráfico: /Archivo/Crear conjunto de datos

# ols Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opciones: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
		<@lit="--robust"> (desviaciones típicas robustas)
		<@lit="--quiet"> (suprime la presentación de los resusltados)
		<@lit="--no-df-corr"> (suprime la corrección de grados de libertad)
		<@lit="--print-final"> (ver más abajo)
Ejemplos: 	<@lit="ols 1 0 2 4 6 7">
		<@lit="ols y 0 x1 x2 x3 --vcv">
		<@lit="ols y 0 x1 x2 x3 --quiet">

Calcula las estimaciones de mínimos cuadrados ordinarios (MCO) con <@var="vardep"> como variable dependiente y siendo <@var="varindeps"> la lista de variables independientes. Las variables se pueden determinar por nombre o por su número; hay que usar el número cero para el término constante. 

Además de las estimaciones de los coeficientes y de las desviaciones típicas, el programa también presenta los valores p de los estadísticos <@itl="t"> (a dos colas) y <@itl="F">. Un valor p inferior a 0,01 indica significatividad al nivel del 1 por ciento y se denota mediante <@lit="***">. <@lit="**"> indica un nivel de significatividad entre el 1 y 5 por ciento y <@lit="*"> indica significatividad entre el 5 y 10 por ciento. También se presentan algunos estadísticos de selección de modelos (se describen en Ramanathan, Sección 4.3). 

Si se da la opción <@lit="--no-df-corr">, no se aplica la corrección habitual de grados de libertad al calcular la estimación de la varianza de las perturbaciones (y así tampoco en la estimación de las desviaciones típicas de los estimadores de los parámetros). 

La opción <@lit="--print-final"> es aplicable sólo en el contexto de un bucle (ver <@ref="loop">). Se encarga de que las regresiones se ejecuten "silenciosamente" en todas las iteraciones excepto la iteración final del bucle. Ver <@pdf="el manual de gretl"> para más detalles. 

Algunas variables que se definen internamente al ejecutar la instrucción <@lit="ols">, pueden recuperarse mediante la instrucción <@ref="genr">, teniendo en cuenta que <@lit="genr"> debe invocarse immediatamente después de la instrucción <@lit="ols">. 

Mediante la instrucción <@ref="set"> puede ajustarse la fórmula específica que se usa para generar las desviaciones típicas robustas (cuando se da la opción <@lit="--robust">). 

Menú gráfico: /Modelo/Mínimos cuadrados ordinarios
Otro acceso: Botón beta con sombrero en la barra de herramientas

# omit Tests

Argumento: 	<@var="listavar"> 
Opciones: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
		<@lit="--quiet"> (no mostrar las estimaciones del modelo reducido)
Ejemplo: 	<@lit="omit 5 7 9">

Esta instrucción debe invocarse justo después de una instrucción de estimación. Las variables seleccionadas se omiten del modelo anterior y se estima el nuevo modelo. Si se omite más de una variable, se presentará el estadístico <@itl="F"> de Wald para las variables omitidas y su valor p (sólo para el método MCO). Un valor p inferior a 0,05 indica que los coeficientes son conjuntamente significativos al nivel de significación del 5 por ciento. 

Si se da la opción <@lit="--quiet"> el resultado que se muestra es sólo el contraste de significación conjunta de las variables omitidas, en caso contrario, también se presentan las estimaciones del modelo reducido. En este último caso, la opción <@lit="--vcv"> hace que también se muestre la matriz de covarianzas de los coeficientes estimados. 

Menú gráfico: ventana de Modelo, /Contrastes/omitir variables

# omitfrom Tests

Argumentos: 	<@var="ID_modelo"> <@var="listavar"> 
Opción: 	<@lit="--quiet"> (no mostrar las estimaciones del modelo reducido)
Ejemplo: 	<@lit="omitfrom 2 5 7 9">

Funciona igual que <@ref="omit">, excepto que aquí Vd. tiene que especificar un modelo anterior (usando su número ID identificador de modelo, que se presenta al principio de los resultados del modelo) que se toma como base para omitir las variables. En el ejemplo de arriba se omiten del Modelo 2 las variables con números 5, 7 y 9. 

Menú gráfico: Ventana de Modelo, /Contrastes/omitir variables

# open Dataset

Argumento: 	<@var="fichero_de_datos"> 

Abre un fichero de datos. Si ya hay un fichero de datos abierto, se reemplaza por el que ahora se abre. El programa tratará de detectar el formato del fichero de datos (formato nativo de gretl, texto plano, CSV o BOX1). 

Esta instrucción también se puede usar para abrir una base de datos (de fromato gretl o RATS 4.0). En este caso, después debería ejecutarse la instrucción <@ref="data"> para extraer de ella series determinadas. 

Menú gráfico: /Archivo/Abrir datos
Otro acceso: Arrastrar un fichero de datos sobre gretl (en MS Windows o Gnome)

# outfile Printing

Argumentos: 	<@var="nombre_de_fichero"> <@var="opción"> 
Opciones: 	<@lit="--append"> (añadir a un fichero)
		<@lit="--close"> (cerrar el fichero)
		<@lit="--write"> (sobreescribir el fichero)
Ejemplos: 	<@lit="outfile --write regres.txt">
		<@lit="outfile --close">

Envía los resultados a <@var="nombre_de_fichero">, hasta nuevo aviso. Use la opción <@lit="--append"> para añadir los resultados a un fichero ya existente o <@lit="--write"> para empezar un nuevo fichero (o sobreescribir uno existente). De esta forma sólo se puede abrir un fichero en cada momento. 

La opción <@lit="--close"> se usa para cerrar un fichero de resultados que estuviera abierto previamente. Los resultados se enviarán entonces a la salida por defecto. 

En el primer ejemplo de arriba, se abre el fichero <@lit="regres.txt"> para escritura, y en el segundo se cierra. Esta secuencia tendría sentido sólo si se ejecutaran algunas instrucciones antes de <@lit="--close">. Por ejemplo si se invocara una instrucción <@lit="ols">, sus resultados irían a <@lit="regres.txt"> en lugar de a la pantalla. 

# panel Dataset

Opciones: 	<@lit="--cross-section"> (secciones cruzadas apiladas)
		<@lit="--time-series"> (series temporale apiladas)

Indica que el conjunto de datos actual debe ser interpretado como un panel (combinando secciones cruzadas y series temporales). Por defecto, o usando la opción <@lit="--time-series">, se considera que el conjunto de datos está en la forma de series temporales apiladas (los sucesivos bloques de datos contienen series temporales para cada unidad de sección cruzada). Con la opción <@lit="--cross-section">, elconjunto de datos se lee como secciones cruzadas apiladas (los sucesivos bloques de datos contienen secciones cruzadas para cada periodo temporale). Ver también <@ref="setobs">. 

Menú gráfico: /Muestra/Interpretar como panel

# pca Statistics

Argumento: 	<@var="listavar"> 
Opciones: 	<@lit="--save-all"> (guardar todos los componentes)
		<@lit="--save"> (guardar los componentes más importantes)

Análisis de componentes principales. Presenta los valores propios de la matriz de correlación de las variables de la lista <@var="listavar"> y la proporción de la varianza conjunta explicada por cada uno de los componentes. También presenta los vectores propios correspondientes (o "ponderaciones de los componentes"). 

Si se da la opción <@lit="--save">, los componentes con valorres propios mayores que 1,0 se guardan como variables en el conjunto de datos, con nombres <@lit="PC1">, <@lit="PC2"> y así sucesivamente. Estas variables artificiales se forman como la suma de (ponderaciones de los componentes) por (<@lit="Xi"> estandarizadas), donde <@lit="Xi"> denota la <@itl="i">-ésima variable de la lista <@var="listavar">. 

Si se da la opción <@lit="--save-all">, se guardan todos los componentes de la manera que se ha descrito arriba. 

Menú gráfico: Menú emergente de la ventana principal (selección múltiple)

# pergm Statistics

Argumento: 	<@var="nombre_var"> 
Opción: 	<@lit="--bartlett"> (usar la venatana de retardos de Bartlett)

Calcula y presenta (y si no se ejecuta en modo batch, representa gráficamente) el espectro de la variable especificada. Sin la opción <@lit="--bartlett"> se ofrece el periodograma muestral; con dicha opción, se utiliza una ventana de retardos de Bartlett de longitud <@fig="tworootT"> (donde <@itl="T"> es el tamaño muestral) para estimar el espectro (ver Capítulo 18 del libro de Greene <@itl="Econometric Analysis">). Cuando se presenta el periodograma muestral, también se proporciona un contraste <@itl="t"> sobre integración fraccional de la serie ("memoria larga"): la hipótesis nula es que el orden de integración es cero. 

Menú gráfico: /Variable/Espectro
Otro acceso: Menú emergente de la ventana principal (selección simple)

# plot Graphs

Argumento: 	<@var="listavar"> 
Opción: 	<@lit="--one-scale"> (forzar una sóla escala)

Representa gráficamente los valores de las variables especificadas, para el rango muestral que esté actualmente activo, utilizando símbolos ASCII. Cada línea indica una observación y los valores se representan horizontalmente. Por defecto, las variables se cambian a la escala más adecuada. Ver también <@ref="gnuplot">. 

# print Printing

Argumentos: 	<@var="listavar"> o <@var="cadena_literal"> 
Opciones: 	<@lit="--byobs"> (por observaciones)
		<@lit="--ten"> (usar 10 dígitos significativos)
Ejemplos: 	<@lit="print x1 x2 --byobs">
		<@lit="print "Esto es una cadena de caracteres"">

Si se da una lista <@var="listavar">, presenta los valores de las variables especificadas; si no se da ninguna lista, muestra los valores de todas las variables del conjunto de datos actual. Si se da la opción <@lit="--byobs">, los datos se presentan 'por observación', en caso contrario, se presentan 'por variable'. Si se da la opción <@lit="--ten">, los datos se presentan por variable mostrando 10 dígitos significativos. 

Si el argumento de la instrucción <@lit="print"> es una cadena literal (que debe comenzar con comillas dobles, <@lit=""">), la cadena se presenta tal y como está. Ver también <@ref="printf">. 

Menú gráfico: /Datos/Mostrar valores

# printf Printing

Argumentos: 	<@var="format"> <@var="args"> 

Presenta valores escalares bajo el control de una cadena de caracteres (proporcionando así un subconjunto de las utilidades de la instrucción <@lit="printf()"> del lenguaje de programación C). Los formatos que se reconocen son <@lit="%g"> y <@lit="%f">, en cada caso con los diferentes modificadores disponibles en C. Ejemplos: el formato <@lit="%.10g"> presenta un valor con 10 dígitos significativos; <@lit="%12.6f"> presenta una valor con 6 decimales y con una anchura de 12 caracteres. 

La propia cadena de caracteres que indica el formato debe de estar incluida entre comillas. Los valores a mostrar deben seguir el formato de la cadena, separados por comas. Estos valores deberían de tener la forma de (a) nombres de variables del conjunto de datos, o (b) expresiones que sean válidas para la instrucción <@lit="genr">. En el siguiente ejemplo se muestran los valores de dos variables más el de una expresión calculada: 

<code>          
	ols 1 0 2 3
	genr b = coeff(2)
	genr dt_b = stderr(2)
	printf "b = %.8g, desviación típica %.8g, t = %.4f\n", b, dt_b, b/dt_b
</code>

La largura máxima de una cadena de formato es de 127 caracteres. Se reconocen las secuencias de escape <@lit="\n"> (nueva línea), <@lit="\t"> (tabulador), <@lit="\v"> (tabulador vertical) y <@lit="\\"> (backslash literal). Para presentar un signo de porcentaje literal use <@lit="%%">. 

# probit Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)

La variable dependiente debería ser una variable binaria. Se obtienen las estimaciones máximo-verosímiles de los coeficientes de las variables <@var="varindeps"> por medio de mínimos cuadrados iterativos (el método EM o Expectation–Maximization). Como el modelo no es lineal las pendientes dependen de los valores de las variables independientes: las pendientes que se presentan están evaluadas en las medias de dichas variables. El estadístico chi-cuadrado sirve para contrastar la hipótesis nula de que todos los coeficientes, excepto la constante, son cero. 

El análisis Probit de proporciones no está aún implementado en gretl. 

Menú gráfico: /Modelo/Probit

# pvalue Utilities

Argumentos: 	<@var="dist"> [ <@var="params"> ] <@var="xval"> 
Ejemplos: 	<@lit="pvalue z zscore">
		<@lit="pvalue t 25 3.0">
		<@lit="pvalue X 3 5.6">
		<@lit="pvalue F 4 58 fval">
		<@lit="pvalue G xbar varx x">

Calcula el área a la derecha de <@var="xval"> en la distribución especificada (<@lit="z"> para Gaussiana, <@lit="t"> para la <@itl="t"> de Student, <@lit="X"> para la chi-cuadrado, <@lit="F"> para la <@itl="F"> y <@lit="G"> para la distribución gamma). Para las ditribuciones <@itl="t"> y chi-cuadrado deben proporcionarse los grados de libertad; para la <@itl="F"> hay que proporcionar los grados de libertad del numerador y del denominador; y para la distribución gamma se necesitan la media y la varianza. 

Menú gráfico: /Utilidades/buscador de valores-p

# pwe Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
Ejemplo: 	<@lit="pwe 1 0 2 4 6 7">

Calcula estimaciones de los parámetros utilizando el procedimiento de Prais–Winsten, un método de Mínimos cuadrados generalizados factibles que está diseñado para tener en cuenta la autocorrelación de primer orden del término de error. El procedimiento es iterativo, igual que <@ref="corc">; la diferencia es que mientras el método de Cochrane–Orcutt desperdicia la primera observación, el de Prais–Winsten la utiliza. Para más detalles, ver por ejemplo el Capítulo 13 del libro de Greene <@itl="Econometric Analysis"> (2000). 

Menú gráfico: /Modelo/Serie temporal/Prais-Winsten

# quit Utilities

Sale del programa, dándole a Vd. la opción de guardar las órdenes y resultados de su sesión al salir. 

Menú gráfico: /Archivo/Salir

# rename Dataset

Argumentos: 	<@var="var_número"> <@var="nuevo_nombre"> 

Cambia el nombre de la variable con número de identificación <@var="var_número"> a <@var="nuevo_nombre">. El número <@var="var_número"> debe estar entre el 1 y el número de variables en el conjunto de datos. El nuevo nombre debe tener como máximo 8 caracteres, debe empezar con una letra y debe estar formado sólo por letras dígitos y el carácter de subrayado (<@lit="_">). character. 

Menú gráfico: /Variable/Editar atributos
Otro acceso: Menú emergente de la ventana principal (selección simple)

# reset Tests

Debe ejecutarse después de la estimación de un modelo vía MCO. Realiza el contraste de especificación de modelos (no linealidad) RESET de Ramsey. Para ello añade a la regresión el cuadrado y el cubo de los valores ajustados y calcula el estadístico <@itl="F"> para la hipótesis nula de que los parámetros de las dos variables añadidas son cero. 

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste RESET de Ramsey

# restrict Tests

Evalúa un conjunto de restricciones sobre los parámetros del último modelo estimado. En modo "guión de instrucciones", el conjunto de restricciones debe incluirse entre "restrict" y "end restrict", pero en la caja de diálogo sobre restricciones (en el entorno gráfico) pueden omitirse esas líneas. 

Cada restricción del conjunto debe expresarse como una ecuación, con una combinación lineal de los parámetros a la izquierda y un valor numérico a la derecha del signo igual. Los parámetros se referencian en la forma b<@var="N">, donde <@var="N"> representa la posición en la lista de regresores, comenzando en cero. Por ejemplo, <@lit="b1"> denota al segundo parámetro de la regresión. 

El segundo y siguientes términos <@lit="bN"> de una ecuación pueden ir premultiplicados por un número, utilizando <@lit="*"> para representar la multiplicación, por ejemplo <@lit="3.5*b4">. 

He aquí un ejemplo de un conjunto de restricciones: 

<code>          
	restrict
	 b1 = 0
	 b2 - b3 = 0
	 b4 + 2*b5 = 1
	end restrict
</code>

Las restricciones se evalúan mediante un contraste F de Wald, usando la matriz de covarianzas de los coeficientes del modelo en cuestión. 

Menú gráfico: Ventana de Modelo, /Contrastes/Restricciones lineales

# rhodiff Transformations

Argumentos: 	<@var="listarho"> ; <@var="listavar"> 
Ejemplos: 	<@lit="rhodiff .65 ; 2 3 4">
		<@lit="rhodiff r1 r2 ; x1 x2 x3">

Crea las versiones rho-diferenciadas de las variables (dadas por nombre o número) de la lista <@var="listavar"> y las añade al conjunto de datos, usando el sufijo <@lit="#"> para las nuevas variables. Dada la variable <@lit="v1"> una variable de <@var="listavar">, y las entradas <@lit="r1"> y <@lit="r2"> de <@var="listarho">, se crea 

<code>          
	v1# = v1 - r1*v1(-1) - r2*v1(-2)
</code>

Las entradas de <@var="listarho"> pueden darse como valores numéricos o como nombres de variables definidas previamente. 

# rmplot Graphs

Argumento: 	<@var="nombre_var"> 

Gráfico Rango–media plot: esta instrucción crea un sencillo gráfico para ayudar a decidir si una serie temporal, <@itl="y">(t), tiene varianza constante o no. Se toma la muestra completa t=1,...,T y se divide en pequeñas submuestras de tamaño arbitrario <@itl="k">. La primera submuestra se forma con <@itl="y">(1),...,<@itl="y">(k), la segunda con <@itl="y">(k+1), ..., <@itl="y">(2k), y así sucesivamente. Para cada submuetra se calcula la media muestral y el rango (= el máximo menos el mínimo), y se forma un gráfico con las medias en el eje horizontal y los rangos en el vertical. Así, cada submuestra está representada por un punto en este plano. Si la varianza de la serie es constante, se espera que los rangos de las submuestras sean independientes de las medias; si vemos que los puntos se distribuyen a lo largo de una línea de creciente, esto sugiere que la varianza de la serie aumenta con la media; si los puntos siguen una línea decreciente esto indica que la varianza disminuye a medida que la media aumenta. 

Además del gráfico, gretl presenta las medias y los rangos de cada submuestra, el coeficiente para la pendiente en una regresión MCO de los rangos sobre las medias y el valor p para el contraste de la hipótesis nula de que dicha pendiente es cero. Si el coeficiente de la pendiente es significativo, al nivel de significación del 10 por ciento, se muestra también en el gráfico la recta de regresión estimada de los rangos sobre las medias. 

Menú gráfico: /Variable/Gráfico rango-media

# run Programming

Argumento: 	<@var="inputfile"> 

Ejecuta las instrucciones de <@var="inputfile"> y devuelve el control a la línea de instrucciones. 

Menú gráfico: Icono de 'ejecutar' en la ventana de guión de instrucciones

# runs Tests

Argumento: 	<@var="nombre_var"> 

Realiza el contraste "rachas" (no paramétrico) de aleatoriedad de la variable especificada. Si Vd. desea contrastar la aleatoriedad de las desviaciones respecto a la mediana, para una variable denominada <@lit="x1"> con mediana distinta de cero, puede hacer lo siguiente: 

<code>          
	genr signx1 = x1 - median(x1)
	runs signx1
</code>

Menú gráfico: /Variable/Contraste de rachas

# scatters Graphs

Argumentos: 	<@var="yvar"> ; <@var="xlistavar"> o <@var="ylistavar ; xvar"> 
Ejemplos: 	<@lit="scatters 1 ; 2 3 4 5">
		<@lit="scatters 1 2 3 4 5 6 ; 7">

Dibuja gráficos bivarianes, de la variable <@var="yvar"> con respecto a todas las variables de la lista <@var="xlistavar">, o de todas las variables de la lista <@var="ylistavar"> con respecto a <@var="xvar">. El primer ejemplo de arriba sitúa la variable 1 en el eje <@itl="y"> y realiza cuatro gráficos, el primero con la variable 2 en el eje <@itl="x">, el segundo con la variable 3 en el eje <@itl="x">, y así sucesivamente. En el segundo ejemplo se representa cada una de las variables 1,..., 6 con respecto a la variable 7 en el eje <@itl="x">. Revisar un conjunto de gráficos como estos puede ser útil al realizar análisis exploratorio de datos. El número máximo de gráficos es seis; cualquier otra variable extra en la lista será ignorada. 

Menú gráfico: /Datos/Gráficos bivariantes múltiples

# set Programming

Argumentos: 	<@var="variable"> <@var="valor"> 

Establece los valores de varios parámetros del programa. Los valores dados permanecen vigentes durante todo el desarrollo de la sesión de gretl, a no ser que se cambien con una nueva llamada a la instrucción <@lit="set">. Los parámetros que pueden determinarse de esta forma se enumeran abajo. Hay que señalar que los parámetros de <@lit="hac_lag"> y <@lit="hc_version"> se usan cuando se elige la opción <@lit="--robust"> en la instrucción <@lit="ols">. 

<indent>
• <@lit="echo">: <@lit="off"> u <@lit="on"> (por defecto). Suprime o activa el eco de las instrucciones en la salida de gretl. 
</indent>

<indent>
• <@lit="qr">: <@lit="on"> u <@lit="off"> (por defecto). Utiliza QR en lugar de la descomposición de Cholesky al calcular las estimaciones por MCO. 
</indent>

<indent>
• <@lit="hac_lag">: <@lit="nw1"> (por defecto) o <@lit="nw2">, o un entero. Establece el retardo máximo, <@itl="p">, usado al calcular desviaciones típicas HAC (Heteroskedasticity and Autocorrelation Consistent) usando el método de Newey-West para datos de series temporales. <@lit="nw1"> y <@lit="nw2"> representan dos variantes para el cálculo automático basadas en el tamaño muestral, <@itl="T">: para nw1, <@fig="nw1">, y para nw2, <@fig="nw2">. 
</indent>

<indent>
• <@lit="hc_version">: 0 (por defecto), 1, 2 o 3. Determina la variante usada al calcular desviaciones típicas consistentes ante heterocedasticidad con datos de sección cruzada. Las opciones corresponden a los valores HC0, HC1, HC2 y HC3 estudiadas por Davidson y MacKinnon en <@itl="Econometric Theory and Methods">, capítulo 5. HC0 produce lo que normalmente se llaman "desviaciones típicas de White". 
</indent>

<indent>
• <@lit="force_hc">: <@lit="off"> (por defecto) u <@lit="on">. Por defecto, con datos de series temporales y cuando se da la opción <@lit="--robust"> en <@lit="ols">, se usa el estimador HAC. Si se establece <@lit="force_hc"> en "on", esto fuerza al cálculo de la Matriz de Covarianzas Consistente ante Heterocedasticidad regular (que no tiene en cuenta la autocorrelación). 
</indent>

<indent>
• <@lit="garch_vcv">: <@lit="unset">, <@lit="hessian">, <@lit="im"> (matriz de información) , <@lit="op"> (matriz de productos externos), <@lit="qml"> (estimador QML), <@lit="bw"> (Bollerslev–Wooldridge). Especifica la variante que se usará para estimar la matriz de covarianzas de los coeficientes para modelos GARCH. Si se da <@lit="unset"> (por defecto) entonces se usa el Hessiano a no ser que se dé también la opción "robust" para la instrucción garch, en cuyo caso se usa QML. 
</indent>

<indent>
• <@lit="hp_lambda">: <@lit="auto"> (por defecto), o un valor numérico. Determina el parámetro de suavizado para el filtro de Hodrick–Prescott (ver la función <@lit="hpfilt"> bajo la instrucción <@lit="genr">). El valor por defecto es usar 100 veces el cuadrado de la periodicidad, lo cual da 100 para datos anuales, 1600 para trimestrales, y así sucesivamente. 
</indent>

# setobs Dataset

Argumentos: 	<@var="periodicidad"> <@var="obs_inicial"> 
Ejemplos: 	<@lit="setobs 4 1990:1">
		<@lit="setobs 12 1978:03">
		<@lit="setobs 20 1:01">

Fuerza al programa a interpretar el conjunto de datos actual como serie temporal o como panel, cuando los datos se han leído como series simples sin fechas. La <@var="periodicidad"> debe ser un entero; <@var="obs_inicial"> es una cadena de caracteres que representa la fecha o identificación de panel de la primera observación. Ver también <@ref="panel">. 

Menú gráfico: /Muestra/Establecer frecuencia, observación inicial

# setmiss Dataset

Argumentos: 	<@var="valor"> [ <@var="listavar"> ] 
Ejemplos: 	<@lit="setmiss -1">
		<@lit="setmiss 100 x2">

Hace que el programa interprete algún valor numérico concreto (el primer parámetro de la instrucción) como código para valor "ausente", en el caso de datos importados. Si este valor es el único parámetro, como en el primer ejemplo de arriba, la interpretación se aplicará a todas las series del conjunto de datos. Si después de <@var="valor"> sigue una lista de variables, por nombre o número, la interpretación se restringe a las variables especificadas. Así, en el segundo ejemplo el valor 100 se interpreta como código para "valor ausente", pero sólo para la variable <@lit="x2">. 

Menú gráfico: /Muestra/Establecer código de 'valor perdido'

# shell Utilities

Argumento: 	<@var="instrucción_de_shell"> 
Ejemplos: 	<@lit="! ls -al">
		<@lit="! notepad">

Un <@lit="!"> al comienzo de una línea de instrucciones se interpreta como un escape al shell del usuario. Así se pueden ejecutar instrucciones de shell arbitrarias desde dentro de gretl. 

# smpl Dataset

Variantes: 	<@lit="smpl"> <@var="startobs endobs">
		<@lit="smpl"> <@var="+i -j">
		<@lit="smpl"> <@var="dumvar"> <@lit="--dummy">
		<@lit="smpl"> <@var="condition"> <@lit="--restrict">
		<@lit="smpl"> <@lit="--no-missing [ "><@var="varlist"> <@lit="]">
		<@lit="smpl"> <@var="n"> <@lit="--random">
		<@lit="smpl full">
Ejemplos: 	<@lit="smpl 3 10">
		<@lit="smpl 1960:2 1982:4">
		<@lit="smpl +1 -1">
		<@lit="smpl x > 3000 --restrict">
		<@lit="smpl y > 3000 --restrict --replace">
		<@lit="smpl 100 --random">

Cambia el rango muestral. El nuevo rango puede definirse de varias formas. En la primera forma alternativa (y los dos primeros ejemplos) de arriba <@var="startobs"> y <@var="endobs"> deben ser coherentes con la periodicidad de los datos. Cualquiera de ellos se puede sustituir por un punto y coma para dejar el valor sin cambios. En la segunda forma los enteros <@var="i"> y <@var="j"> (que pueden ser postivos o negativos y deberían tener signo) se toman como offsets respecto al rango muestral existente. En la tercera forma, <@var="dummyvar"> debe ser una variable indicador con valores 0 o 1 en cada observación; la muestra se restringirá a las observaciones en las que el valor es 1. La cuarta forma, usando <@lit="--restrict"> restringe la muestra a las observaciones que satisfacen la condición Booleana (que se especifica de acuerdo a la sintaxis de la instrucción <@ref="genr">). 

Con la opción <@lit="--no-missing">, si se especifica <@var="listavar">, las observaciones se seleccionan con la condición de que todas las variables de <@var="listavar"> tengan valores válidos en esa observación; cuando no se especifica <@var="listavar">, las observaciones se seleccionan con la condición de que <@itl="todas"> las variables tengan valores validos (no ausentes). 

Con la opción <@lit="--random">, se extrae del conjunto de datos el número de observaciones especificado, de manera aleatoria. Si se desea poder replicar esta selección más adelante, se debe establecer primero una semilla para el generador de números aleatorios (Véase la instrucción <@ref="set">). 

La forma final, <@lit="smpl full">, restablece el rango muestral completo. 

Nótese que las restricciones sobre la muestra son, por defecto, acumulativas: la base para cualquier orden <@lit="smpl"> es la muestra actual. Si Vd. desea que la instrucción actúe reemplazando cualquier restricción previa, puede añadir la opción <@lit="--replace"> al final de la instrucción. 

Puede usarse la variable interna <@lit="obs"> junto con la opción <@lit="--restrict"> de <@lit="smpl"> para excluir observaciones particulares de la muestra. Por ejemplo, 

<code>          
	smpl obs!=4 --restrict
</code>

quitará sólo la cuarta observación. Si los datos se identifican mediante etiquetas, 

<code>          
	smpl obs!="USA" --restrict
</code>

quitará la observación con etiqueta "USA". 

Con respecto a las formas <@lit="--dummy">, <@lit="--restrict"> y <@lit="--no-missing"> de <@lit="smpl">, hay que señalar que cualquier información "estructural" en el fichero de datos (referente a la estructura de series temporales o de panel de los datos) se pierde al ejecutar esta orden. Es posible reimponer la estructura inicial con la instrucción <@ref="setobs">. 

Véase <@pdf="el manual de gretl"> para más detalles. 

Menú gráfico: /Muestra

# spearman Statistics

Argumentos: 	<@var="x"> <@var="y"> 
Opción: 	<@lit="--verbose"> (mostrar los datos ordenados)

Presenta el coeficiente de rango de correlación para las dos variables <@itl="x"> e <@itl="y">. No es necesario antes ordenar y hacer el ranking de las variables, la función se encarga de ello. 

El ranking automático es de mayor a menor (es decir, el mayor valor de los datos obtiene rango 1). Si Vd. necesita invertir este ranking cree una nueva variable que sea el negativo de la primera original. Por ejemplo: 

<code>          
	genr altx = -x
	spearman altx y
</code>

Menú gráfico: /Modelo/Correlación por Rangos

# square Transformations

Argumento: 	<@var="listavar"> 
Opción: 	<@lit="--cross"> (además de los cuadrados genera los productos cruzados)

Genera variables nuevas que son los cuadrados de las variables de la lista <@var="listavar"> (más los productos cruzados, si se da la opción <@lit="--cross">). Por ejemplo, <@lit="square x y"> generará <@lit="sq_x"> = <@lit="x"> cuadrado, <@lit="sq_y"> = <@lit="y"> cuadrado and (optionalmente) <@lit="x_y"> = <@lit="x"> por <@lit="y">. Si una determinada variable es una variable ficticia, no será elevada al cuadrado, ya que se obtendría lo mismo. 

Menú gráfico: /Datos/Añadir variables/cuadrados delas variables

# store Dataset

Argumentos: 	<@var="fichero_de_datos"> [ <@var="listavar"> ] 
Opciones: 	<@lit="--csv"> (usar formato CSV)
		<@lit="--gnu-octave"> (usar formato GNU Octave)
		<@lit="--gnu-R"> (usar formato GNU R)
		<@lit="--traditional"> (usar el formato tradicional de ESL)
		<@lit="--gzipped"> (aplicar la compresión mediante gzip)
		<@lit="--dat"> (usar el formato ASCII de PcGive)

Guarda el conjunto de datos completo o, si se suministra una lista <@var="listavar">, el subconjunto especificado de variables del conjunto de datos actual, al fichero dado en <@var="fichero_de_datos">. 

Por defecto los datos se guardan en formato gretl "nativo", pero las distintas opciones permiten guardarlos en varios formatos alternativos. Los datos CSV (Comma-Separated Values) pueden ser leídos por programas de hoja de cálculos y también pueden manipularse mediante un editor de textos. Los formatos de Octave, R y PcGive están diseñados para el uso con estos respectivos programas. La compresión mediante Gzip puede ser útil para grandes conjuntos de datos. Ver <@pdf="el manual de gretl"> para detalles sobre los distintos formatos. 

Hay que señalar que las variables escalares no serán guardadas automáticamente: si Vd. desea guardar escalares debe escribirlas explícitamente en la lista <@var="listavar">. 

Menú gráfico: /Archivo/Guardar datos; /Archivo/Exportar datos

# summary Statistics

Argumento: 	[ <@var="listavar"> ] 

Presenta los estadísticos principales de las variables de la lista <@var="listavar">, o si se omite <@var="listavar">, de todas las variables del conjunto de datos. Se muestran la media, desviación típica, coeficiente de variación (= dt/media), mediana, mínimo, máximo, coeficiente de asimetría y exceso de curtosis. 

Menú gráfico: /Datos/Estadísticos principales
Otro acceso: Menú emergente de la ventana principal

# system Estimation

Argumentos: 	<@var="type"> <@var="savevars"> 
Ejemplos: 	<@lit="system type=sur">
		<@lit="system type=sur save=resids">
		<@lit="system type=3sls save=resids,fitted">

Da comienzo a un sistema de ecuaciones. Actualmente se soportan dos tipos de sistemas: <@lit="sur"> (Seemingly Unrelated Regressions, ecuaciones de regresión aparentemente no relacionadas) y <@lit="3sls"> (Three-Stage Least Squares, mínimos cuadrados en tres etapas). En el campor opcional <@lit="save="> se puede especificar si guardar los residuos (<@lit="resids">) y/o los valores ajustados (<@lit="fitted">). El sistemna debe contener al menos dos ecuaciones, que se especifican por medio de la instrucción <@lit="equation">, y debe terminarse con la línea <@lit="end system">. 

En el contexto de un sistema de Mínimos Cuadrados en Tres Etapas, Vd. puede proporcionar una lista de instrumentos (mediante nombre o número). Esta debería ir en una linea por separado dentro del bloque <@lit="system">, precedido de la palabra <@lit="instr">. 

# tabprint Printing

Argumento: 	[ <@var="-f fichero"> ] 
Opción: 	<@lit="--complete"> (Crea un documento completo)

Debe ejecutarse después de la estimación de un modelo. Presenta el modelo estimado en forma de una tabla de LaTeX. Si se especifica un nombre de fichero por medio de la opción <@lit="-f"> el resultado va a ese fichero, en caso contrario va a un fichero con un nombre de la forma <@lit="model_N.tex">, donde <@lit="N"> es el número de modelos estimados hasta ese momento en la sesión actual de gretl. Ver también <@ref="eqnprint">. 

Si se da la opción <@lit="--complete"> el fichero LaTeX será un documento completo, listo para ser procesado; en caso contrario debería ser incluido en un documento ya formado. 

Menú gráfico: Ventana de Modelo, /LaTeX

# testuhat Tests

Debe ejecutarse después de una instrucción de estimación. Da la distribución de frecuencias de los residuos del modelo y un contraste chi-cuadrado de normalidad, basado en el procedimiento propuesto por Doornik y Hansen (1984). 

Menú gráfico: Ventana de Modelo, /Contrastes/normalidad de los residuos

# tobit Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> 
Opciones: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
		<@lit="--verbose"> (mostrar los detalles de las iteraciones)

Estima un modelo Tobit. Este modelo puede ser adecuado cuando la variable dependiente es una variable "truncada". Por ejemplo, se observan valores positivos y cero de las compras de bienes duraderos por parte de las familias, pero no valores negativos. Sin embargo las decisiones sobre tales compras pueden considerarse como resultados de una disposición subyacente a la compra que puede ser negativa en algunos casos. Para detalles ver el libro de Greene <@itl="Econometric Analysis">, Capítulo 20. 

Menú gráfico: /Modelo/Tobit

# tsls Estimation

Argumentos: 	<@var="vardep"> <@var="varindeps"> ; <@var="instrumentos"> 
Opciones: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)
		<@lit="--robust"> (desviaciones típicas robustas)
Ejemplo: 	<@lit="tsls y1 0 y2 y3 x1 x2 ; 0 x1 x2 x3 x4 x5 x6">

Calcula las estimaciones por mínimos cuadrados en dos etapas (MC2E o VI): <@var="vardep"> es la variable dependiente, <@var="varindeps"> es la lista de variables independientes (incluyendo las variables endógenas del lado derecho) en la ecuación estructural para la cual se necesitan las estimaciones MC2E; y <@var="instrumentos"> es la lista combinada de variables exógenas y predeterminadas en todas las ecuaciones. Si la lista de <@var="instrumentos"> no es al menos tan larga como <@var="varindeps">, el modelo no está identificado. 

En el ejemplo de arriba, las <@lit="y">s son las variables endógenas y las <@lit="x">s son las exógenas y predeterminadas. 

Menú gráfico: /Modelo/Mínimos cuadrados en dos etapas

# var Estimation

Argumentos: 	<@var="orden"> <@var="listavar"> ; <@var="detlist"> 
Opción: 	<@lit="--quiet"> (no mostrar respuestas al impulso etc.)
Ejemplo: 	<@lit="var 4 x1 x2 x3 ; const time">

Construye y estima (usando MCO) un modelo autorregresivo vectorial (VAR). El primer argumento especifica el orden de retardos, despues va la estructura de la primera ecuación. No hay que incluir retardos entre los elementos de <@var="listavar"> — se añadirán automáticamente. El punto y coma separa las variables estocásticas, para las que se incluirán un número <@var="orden"> de retardos, de los terminos determinísticos de <@var="detlist">, tales como la constante, la tendencia temporal y las variables ficticias estacionales. 

De hecho, gretl es capaz de reconocer las variables determinísticas más comunes (constante, tendencia temporal, variables ficticias que no tengan más valores que el 0 y el 1), así que estas no es necesario situarlas después del punto y coma. Variables determinísticas más complejas (p.ej. una tendencia temporal interactuando con una variable ficticia) deben incluirse después del punto y coma. 

Se ejecuta una regresión por separado para cada variable de <@var="listavar">. La salida de cada ecuación presenta los contrastes <@itl="F"> de restricciones cero de todos los retardos de cada variable; un contraste <@itl="F"> de significatividad del retardo máximo; descomposiciones de la varianza de predicción y las funciones impulso-respuesta. 

Las descomposiciones de la varianza y las funciones impulso-respuesta se basan en la descomposición de Cholesky de la matriz de covarianzas contemporánea, y en este contexto el orden en el que se dan las variables (estocásticas) es importante. La primera variable de la lista se supone que es "más exógena" dentro del periodo. 

Menú gráfico: /Modelo/Serie temporal/Autorregresión vectorial (VAR)

# varlist Dataset

Presenta un listado de las variables actualmente disponibles. <@lit="list"> y <@lit="ls"> son sinónimos. 

# vartest Tests

Argumentos: 	<@var="var1"> <@var="var2"> 

Calcula el estadístico <@itl="F"> para contrastar la hipótesis nula de que las varianzas poblacionales de las variables <@var="var1"> y <@var="var2"> son iguales, y muestra su valor p. 

Menú gráfico: /Datos/Diferencia de varianzas

# vif Tests

Debe ejecutarse inmediatamente después de la estimación de un modelo que incluya al menos dos variables independientes. Calcula y muestra los factores de inflación de varianza (VIFs) de los regresores. El factor de inflación de varianza (VIF) del regresor <@itl="j"> se define como 

  <@fig="vif">

donde <@itl="R"><@sub="j"> es el coeficiente de correlación múltiple entre el regresor <@itl="j"> y los demás regresores. El factor tiene un valor mínimo de 1,0 cuando la variable en cuestión es ortogonal a las demás variables independientes. Neter, Wasserman, y Kutner (1990) sugieren inspeccionar el mayor VIF como una medida de diagnóstico para la multicolinealidad; un valor mayor que 10 se suele considerar que indica un grado de multicolinealidad problemático. 

Menú gráfico: Model window, /Tests/collinearity

# wls Estimation

Argumentos: 	<@var="wtvar"> <@var="vardep"> <@var="varindeps"> 
Opción: 	<@lit="--vcv"> (mostrar la matriz de covarianzas)

Calcula las estimaciones de Mínimos cuadrados ponderados usando <@var="wtvar"> como variable de ponderaciones, <@var="vardep"> como variable dependiente y <@var="varindeps"> como lista de variables independientes. En concreto, se ejecuta una regresión MCO de <@var="wtvar"> <@lit="*"> <@var="vardep"> contra <@var="wtvar"> <@lit="*"> <@var="varindeps">. Si <@var="wtvar"> es una variable ficticia, esto es equivalente a eliminar todas las observaciones en las que <@var="wtvar"> tiene valor cero. 

Menú gráfico: /Modelo/Mínimos cuadrados ponderados

