/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCSCROLLEDVIEWPORT_H__
#define __GRDCSCROLLEDVIEWPORT_H__

G_BEGIN_DECLS

#define GRDC_TYPE_SCROLLED_VIEWPORT \
    (grdc_scrolled_viewport_get_type ())
#define GRDC_SCROLLED_VIEWPORT(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_SCROLLED_VIEWPORT, GrdcScrolledViewport))
#define GRDC_SCROLLED_VIEWPORT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_SCROLLED_VIEWPORT, GrdcScrolledViewportClass))
#define GRDC_IS_SCROLLED_VIEWPORT(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_SCROLLED_VIEWPORT))
#define GRDC_IS_SCROLLED_VIEWPORT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_SCROLLED_VIEWPORT))
#define GRDC_SCROLLED_VIEWPORT_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_SCROLLED_VIEWPORT, GrdcScrolledViewportClass))

typedef struct _GrdcScrolledViewport
{
    GtkEventBox event_box;

    /* Motion activates in Viewport Fullscreen mode */
    gboolean viewport_motion;
    guint viewport_motion_handler;

} GrdcScrolledViewport;

typedef struct _GrdcScrolledViewportClass
{
    GtkEventBoxClass parent_class;
} GrdcScrolledViewportClass;

GType grdc_scrolled_viewport_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_scrolled_viewport_new (void);
void grdc_scrolled_viewport_remove_motion (GrdcScrolledViewport *gsv);

G_END_DECLS

#endif  /* __GRDCSCROLLEDVIEWPORT_H__  */

