/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCPUBLIC_H__
#define __GRDCPUBLIC_H__

#include "config.h"

/* Wrapper marcos to make the compiler happy on both signle/multi-threaded mode */
#ifdef HAVE_PTHREAD
#define IDLE_ADD        gdk_threads_add_idle
#define TIMEOUT_ADD     gdk_threads_add_timeout
#define CANCEL_ASYNC    pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS,NULL);pthread_testcancel();
#define CANCEL_DEFER    pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED,NULL);
#define THREADS_ENTER   gdk_threads_enter();pthread_cleanup_push(grdc_public_threads_leave,NULL);
#define THREADS_LEAVE   pthread_cleanup_pop(TRUE);
#else
#define IDLE_ADD        g_idle_add
#define TIMEOUT_ADD     g_timeout_add
#define CANCEL_ASYNC
#define CANCEL_DEFER
#define THREADS_ENTER
#define THREADS_LEAVE
#endif

#define MAX_PATH_LEN 255

#define STRING_DELIMITOR ','

G_BEGIN_DECLS

/* items is separated by STRING_DELIMTOR */
GtkWidget* grdc_public_create_combo_entry (const gchar *text, const gchar *def, gboolean descending);
GtkWidget* grdc_public_create_combo_text_d (const gchar *text, const gchar *def, const gchar *empty_choice);
void grdc_public_load_combo_text_d (GtkWidget *combo, const gchar *text, const gchar *def, const gchar *empty_choice);
GtkWidget* grdc_public_create_combo_map (const gpointer *key_value_list, const gchar *def, gboolean use_icon);
GtkWidget* grdc_public_create_combo_mapint (const gpointer *key_value_list, gint def, gboolean use_icon);
/* A function for gtk_menu_popup to get the position right below the widget specified by user_data */
void grdc_public_popup_position (GtkMenu *menu, gint *x, gint *y, gboolean *push_in, gpointer user_data);
/* Combine two paths into one by correctly handling trailing slash. Return newly allocated string */
gchar* grdc_public_combine_path (const gchar *path1, const gchar *path2);

void grdc_public_threads_leave (void* data);

G_END_DECLS

#endif  /* __GRDCPUBLIC_H__  */

