/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <stdlib.h>
#include <unistd.h>
#include "config.h"
#include "grdcpublic.h"
#include "grdcpixmaps.h"
#include "grdcmain.h"
#include "grdcfilemanager.h"
#include "grdcfileeditor.h"
#include "grdcconnectionwindow.h"
#include "grdcpref.h"
#include "grdcprefdialog.h"

#ifdef HAVE_LIBGCRYPT
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <pthread.h>
#include <gcrypt.h>
GCRY_THREAD_OPTION_PTHREAD_IMPL;
#endif

int
main (int argc, char* argv[])
{
    gint ret;
    gint c;
    gint exec = 0;
    gchar *filename = NULL;
    gint tab = 0;
    gchar *server = NULL;
    gchar *protocol = NULL;

    bindtextdomain (GETTEXT_PACKAGE, GRDC_LOCALEDIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);

#ifdef HAVE_PTHREAD
    g_thread_init (NULL);
    gdk_threads_init ();
#endif

#ifdef HAVE_LIBGCRYPT
    gcry_control (GCRYCTL_SET_THREAD_CBS, &gcry_threads_pthread);
    gcry_check_version (NULL);
    gcry_control (GCRYCTL_DISABLE_SECMEM, 0);
    gcry_control (GCRYCTL_INITIALIZATION_FINISHED, 0);
#endif

    THREADS_ENTER

    gtk_init (&argc, &argv);

    grdc_file_manager_init ();
    grdc_pref_init ();
    grdc_pixmap_init ();

    gtk_window_set_default_icon (GRDC_PIXMAP_LOGO);

    while ((c = getopt (argc, argv, "c:e:np:qs:t:")) != -1)
    {
        switch (c)
        {
        case 'c':
        case 'e':
        case 'n':
        case 'p':
        case 'q':
            if (exec != 0)
            {
                g_print ("%s: Invalid option %c\n", argv[0], c);
                break;
            }
            exec = c;
            if (c == 'c' || c == 'e')
            {
                filename = optarg;
            }
            else if (c == 'p')
            {
                tab = atoi (optarg);
            }
            break;
        case 's':
            server = optarg;
            break;
        case 't':
            protocol = optarg;
            break;
        }
    }

    switch (exec)
    {
    case 'p':
        grdc_pref_dialog_run (NULL, tab);
        return 0;
    case 'q':
        ret = grdc_file_editor_open_temp_full (NULL, TRUE, server, protocol);
        if (ret != GTK_RESPONSE_OK) return 0;
        break;
    case 'n':
        ret = grdc_file_editor_create_full (NULL, TRUE, server, protocol);
        if (ret != GTK_RESPONSE_OK) return 0;
        break;
    case 'c':
        if (!grdc_connection_window_open (NULL, filename, TRUE)) return 0;
        break;
    case 'e':
        ret = grdc_file_editor_open (NULL, filename, TRUE);
        if (ret != GTK_RESPONSE_OK) return 0;
        break;
    default:
        grdc_main_open ();
        break;
    }
    
    gtk_main ();

    THREADS_LEAVE    

    return 0;
}

