/*
 * Copyright 2007-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.artifacts.specs

import org.gradle.api.artifacts.ProjectDependency
import org.gradle.api.artifacts.ExternalDependency
import org.gradle.api.artifacts.Dependency

import spock.lang.Specification

class TypeTest extends Specification {
    def "EXTERNAL matches external dependencies"() {
        expect:
        Type.EXTERNAL.isSatisfiedBy(Mock(ExternalDependency))
        !Type.EXTERNAL.isSatisfiedBy(Mock(ProjectDependency))
        !Type.EXTERNAL.isSatisfiedBy(Mock(Dependency))
    }

    def "PROJECT matches project dependencies"() {
        expect:
        Type.PROJECT.isSatisfiedBy(Mock(ProjectDependency))
        !Type.PROJECT.isSatisfiedBy(Mock(ExternalDependency))
        !Type.PROJECT.isSatisfiedBy(Mock(Dependency))
    }
}
