/*
 * Copyright 2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.artifacts.specs;

import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.specs.Spec;

/**
 * Dependency types.
 */
public enum Type implements Spec<Dependency> {
    EXTERNAL {
        public boolean isSatisfiedBy(Dependency dependency) {
            return dependency instanceof ExternalDependency;
        }
        public boolean isOf(Dependency dependency) {
            return isSatisfiedBy(dependency);
        }
    },
    PROJECT {
        public boolean isSatisfiedBy(Dependency dependency) {
            return dependency instanceof ProjectDependency;
        }
        public boolean isOf(Dependency dependency) {
            return isSatisfiedBy(dependency);
        }
    };


    /**
     * Deprecated. Use isSatisfiedBy() instead.
     */
    @Deprecated
    public abstract boolean isOf(Dependency dependency);
}
