#ifndef GPSSHOGI_SAMPLE_VIEWER_KIFUFILE_H
#define GPSSHOGI_SAMPLE_VIEWER_KIFUFILE_H
#include <qstring.h>
#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"
#include "osl/misc/carray.h"
#include "osl/record/searchInfo.h"
#include "osl/record/record.h"

class KifuFile
{
public:
  virtual KifuFile *nextFile() const = 0;
  virtual KifuFile *prevFile() const = 0;
  virtual ~KifuFile() {}
  const osl::state::SimpleState &getInitialState() {
    loadData();
    return state;
  }
  const osl::stl::vector<osl::Move> &getMoves() {
    loadData();
    return moves;
  }
  const osl::stl::vector<int> &getTime() {
    loadData();
    return time;
  }
  QString getPlayerName(osl::Player player) {
    loadData();
    return playerName[playerToIndex(player)];
  }
  const osl::stl::vector<QString> &getComments() {
    loadData();
    return comments;
  }
  const osl::stl::vector<osl::record::SearchInfo> &getSearchInfo() {
    loadData();
    return searchInfo;
  }
  const osl::vector<QString>& getInitialComment() const 
  {  
    return initial_comment; 
  }
  virtual bool loadData() = 0;
  virtual QString getFilename() { return filename; }
  virtual bool reloadIfChanged() { return false; }
  void getRecordData(const osl::Record& record);
protected:
  KifuFile(QString f) : filename(f) {}

  QString filename;
  osl::misc::CArray<QString,2> playerName;
  osl::state::SimpleState state;
  osl::stl::vector<osl::Move> moves;
  osl::stl::vector<int> time;
  osl::stl::vector<QString> comments;
  osl::stl::vector<osl::record::SearchInfo> searchInfo;
  osl::vector<QString> initial_comment;
};

class CsaFile : public KifuFile
{
public:
  CsaFile(QString filename);
  virtual ~CsaFile() {}
  KifuFile *nextFile() const;
  KifuFile *prevFile() const;
  bool loadData();
  bool reloadIfChanged();
private:
  bool loaded;
  uint lastLoadedTime;
};

class KakinokiFile : public KifuFile
{
public:
  KakinokiFile(QString filename);
  virtual ~KakinokiFile() {}
  KifuFile *nextFile() const;
  KifuFile *prevFile() const;
  bool loadData();
private:
  bool loaded;
};

class Ki2File : public KifuFile
{
public:
  Ki2File(QString filename);
  virtual ~Ki2File() {}
  KifuFile *nextFile() const;
  KifuFile *prevFile() const;
  bool loadData();
private:
  bool loaded;
};

class KisenFile : public KifuFile
{
public:
  KisenFile(QString filename, int index);
  virtual ~KisenFile() {}
  KifuFile *nextFile() const;
  KifuFile *prevFile() const;
  bool loadData();
private:
  int index;
  bool loaded;
};

class UsiFile : public KifuFile
{
public:
  UsiFile(QString filename);
  virtual ~UsiFile() {}
  KifuFile *nextFile() const;
  KifuFile *prevFile() const;
  bool loadData();
private:
  bool loaded;
};

#endif // GPSSHOGI_SAMPLE_VIEWER_KIFUFILE_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
