#ifndef _ANALYSIS_VIEWER_H
#define _ANALYSIS_VIEWER_H
#include "boardAndListTabChild.h"
#include "moveTree.h"

#include "osl/state/simpleState.h"
#include "osl/state/numEffectState.h"
#include "osl/search/simpleHashTable.h"
#include "osl/game_playing/gameState.h"
#include "osl/game_playing/searchPlayer.h"

#include <boost/scoped_ptr.hpp>

namespace osl
{
  namespace search
  {
    class SimpleHashRecord;
    namespace analyzer
    {
      class RecordSet;
    } // namespace analyzer
  }
}

class Q3ListView;
class Q3ListViewItem;
class SearchMoveTree;
class SearchMoveTreeItem;
class SearchDialogImpl;
#if QT_VERSION < 0x040000
#define Q3PopupMenu QPopupMenu
#endif
class Q3PopupMenu;

class AnalysisViewer : public BoardAndListTabChild
{
Q_OBJECT
public:
  AnalysisViewer(QWidget *parent = 0, const char *name = 0);
  virtual QSize sizeHint() const;
  bool analyze(const osl::state::SimpleState& s,
	       const osl::stl::vector<osl::Move>& moves);
  bool analyzeWithSavedValue(const osl::state::SimpleState& s,
			     const osl::stl::vector<osl::Move>& moves);
  const osl::search::SimpleHashRecord *selectedRecord();
  const osl::search::SimpleHashRecord *getRecord() {
    return record;
  }
  int getLimit();
public slots:
  QWidget *moveGenerateDialog();
private slots:
#if QT_VERSION >= 0x040000
  void openMoves(Q3ListViewItem *item);
#else
  void openMoves(QListViewItem *item);
#endif
private:
  void bestMoves(const osl::NumEffectState&, 
		 const osl::search::SimpleHashTable&);
  int getRecordValue(const osl::search::SimpleHashRecord *r,
		     osl::Player turn);
  void saveSearchValue(const SearchDialogImpl& dialog);

  Q3ListView *moveList;
  boost::scoped_ptr<osl::game_playing::SearchPlayer> player;
  const osl::search::SimpleHashRecord *record;

  QString algorithm;
  int algorithmIndex;
  int depthLimit;
  int initialDepthLimit;
  int deepningStep;
  int nodeLimit;
  int tableSizeLimit;
  int tableRecordLimit;
  int multiPVWidth;
  int searchTime;

  static const QString PROGRESS_MTDF;
  static const QString PLAIN_MTDF;
  static const QString PROGRESS_ALPHA_BETA;
  static const QString TEST_ALPHA_BETA;
};

class SearchMoveTree : public MoveTree
{
  Q_OBJECT
public:
  SearchMoveTree(QWidget *parent = 0, const char *name = 0);
  void addRecord(const osl::state::SimpleState& state,
		 const osl::search::SimpleHashTable *table,
		 const osl::search::SimpleHashRecord *record,
		 const osl::game_playing::SearchPlayer *player,
		 const osl::container::MoveStack& history);
  const osl::state::SimpleState initialState() const { return initial_state; }
  const osl::search::SimpleHashTable& getTable() const { return *table; }
protected:
  void showContextMenu(Q3PopupMenu *);
private slots:
  void showQuiescenceRecord();
  void showSubtree();
  void showRecord();
  void showMoves();
  void showMovesInKanji();
private:
  void addRootItem(const osl::search::SimpleHashRecord *record,
		   const osl::container::MoveStack& history);

  osl::state::SimpleState initial_state;
  const osl::search::SimpleHashTable *table;
  const osl::game_playing::SearchPlayer *player;
};
#endif // _ANALYSIS_VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
