/* safeFilter.h
 */
#ifndef _MOVE_ACTION_SAFE_FILTER_H
#define _MOVE_ACTION_SAFE_FILTER_H
#include "osl/state/numEffectState.h"
#include "osl/move_action/concept.h"
#include "osl/move_classifier/safeMove.h"
namespace osl
{
  namespace move_action
  {
    
    /**
     * 自玉に王手がかかっていない状況から
     * 着手して自殺手になる手を除く
     */
    template<Player P,class OrigAction>
    struct SafeFilter
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
    public:
      SafeFilter(const NumEffectState& s, OrigAction & action) 
	: state(s), action(action) {
	assert(state.template getKingPosition<P>().isPieceStand()
	       || !state.template 
	       hasEffectBy<PlayerTraits<P>::opponent>(state.template
						      getKingPosition<P>())
	       || (state.dump(), 0));
      }
      bool isSafeMove(Ptype ptype,Position from,Position to)
      {
	return move_classifier::SafeMove<P>::isMember(state, ptype, from, to);
      }
      void simpleMove(Position from,Position to,Ptype ptype, bool isPromote,Player
#ifndef NDEBUG
		      p
#endif
	){
	assert(p == P);
	if(isSafeMove(ptype,from,to))
	  action.simpleMove(from,to,ptype,isPromote,P);
      
      }
      void unknownMove(Position from,Position to,Piece p1,Ptype ptype,bool isPromote,Player 
#ifndef NDEBUG
		       p
#endif
	){
	assert(p == P);
	if(isSafeMove(ptype,from,to))
	  action.unknownMove(from,to,p1,ptype,isPromote,P);
      }
      /**
       * dropMoveが自殺手になることはない
       */
      void dropMove(Position to,Ptype ptype,Player
#ifndef NDEBUG
		    p
#endif
	){
	assert(p == P);
	action.dropMove(to,ptype,P);
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* _MOVE_ACTION_SAFE_FILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
