# plugs/reload.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.config import config
from gozerbot.plugins import plugins
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliases
from gozerbot.myimport import my_import
import os

plughelp.add('reload', 'reload a plugin')

def handle_reload(bot, ievent):
    """ reload <plugin> .. reload a plugin """
    try:
        plugs = ievent.args
    except IndexError:
        ievent.missing('<list plugins>')
        return
    for plug in plugs:
        plug = plug.lower()
        if plug == 'config':
            config.reload()
            ievent.reply('config reloaded')
            return
        # first check myplugs then dbplugs and finally plugs dir
        got = []
        base = 'myplugs' + os.sep + plug
        if os.path.isfile(base + '.py') or os.path.isdir(base):
            got = plugins.reload('myplugs', plug)
        else:
            if config['dbenable']:
                dbplugs = my_import('gozerplugs.dbplugs.__init__')
                if plug in dbplugs.__all__:
                    got = plugins.reload('gozerplugs.dbplugs', plug)
        if not got:
            plugs = my_import('gozerplugs.plugs.__init__')
            if plug in plugs.__all__:
                got = plugins.reload('gozerplugs.plugs', plug)
        if got:
            ievent.reply('reloaded %s' % ' .. '.join(got))
        else:
            ievent.reply("error reloading %s plugin" % plug)

cmnds.add('reload', handle_reload, 'OPER')
examples.add('reload', 'reload <plugin>', 'reload core')
aliases.data['load'] = 'reload'

def handle_unload(bot, ievent):
    """ unload <plugin> .. unload a plugin """
    try:
        what = ievent.args[0].lower()
    except IndexError:
        ievent.missing('<plugin>')
        return
    if not plugins.exist(what):
        ievent.reply('there is no %s module' % what)
        return
    if plugins.unload(what):
        plugins.disable(what)
        ievent.reply("%s unloaded and disabled" % what)
    else:
        ievent.reply("%s unload failed" % what)

cmnds.add('unload', handle_unload, 'OPER')
examples.add('unload', 'unload <plugin>', 'unload relay')
