# -*- coding: utf-8 -*-
# Copyright (c) 2005-2007 Canonical, GPL

import apt
import subprocess
import gtk
import gtk.gdk
import thread
import time
import os
import tempfile
from gettext import gettext as _

class GtkOpProgress(apt.progress.OpProgress):
  " a simple helper that keeps the GUI alive "

  def update(self, percent):
    while gtk.events_pending():
      gtk.main_iteration()


class PackageWorker(object):
    """
    A class which does the actual package installing/removing.
    """
    # synaptic actions
    (INSTALL, UPDATE) = range(2)

    def run_synaptic(self, id, lock, to_add=None,to_rm=None, action=INSTALL):
        #print "run_synaptic(%s,%s,%s)" % (id, lock, selections)
        cmd = []
        if os.getuid() != 0:
            cmd = ["/usr/bin/gksu",
                   "--desktop", "/usr/share/applications/synaptic.desktop",
                   "--"]
        cmd += ["/usr/sbin/synaptic",
                "--hide-main-window",
                "--non-interactive",
                "-o", "Synaptic::closeZvt=true",
                "--parent-window-id", "%s" % (id) ]

        # create tempfile for install (here because it must survive
        # durng the synaptic call
        f = tempfile.NamedTemporaryFile()
        if action == self.INSTALL:
            # install the stuff
            for item in to_add:
                f.write("%s\tinstall\n" % item)
                #print item.pkgname
            for item in to_rm:
                f.write("%s\tuninstall\n" % item)
            cmd.append("--set-selections-file")
            cmd.append("%s" % f.name)
            f.flush()
        elif action == self.UPDATE:
            #print "Updating..."
            cmd.append("--update-at-startup")
        self.return_code = subprocess.call(cmd)
        lock.release()
        f.close()

   
    def perform_action(self, window_main, to_add=None, to_rm=None):
        """ 
        install/remove the given set of packages 
        
        return True on success 
               False if any of the actions could not be performed
        """
        window_main.set_sensitive(False)
        window_main.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
        lock = thread.allocate_lock()
        lock.acquire()
        t = thread.start_new_thread(self.run_synaptic,(window_main.window.xid,lock,to_add, to_rm, self.INSTALL))
        while lock.locked():
            while gtk.events_pending():
                gtk.main_iteration()
            time.sleep(0.05)

        # check if the requested package really got installed
        # we can not use the exit code here because gksu does
        # not transport the exit code over
        result = True
        cache = apt.Cache(GtkOpProgress())
        for pkgname in to_add:
            if not cache[pkgname].isInstalled:
                result = False
                break
        for pkgname in to_rm:
            if cache[pkgname].isInstalled:
                result = False
                break
        window_main.set_sensitive(True)
        window_main.window.set_cursor(None)
        return result
