import os
import signal
import time
import ConfigParser

class TestConfigFile:
    def __init__(self, filename = ""):
        """Sets default values """
        if filename != "":
            self.loadTestConfigFile(filename);
        else:
	    self.host = '192.168.3.110'
	    self.port = 6543
	    self.db_user = 'mythtv'
	    self.db_passwd = 'mythtv'
	    self.db_name = 'mythconverg'
	    self.filename = '1004_20070510161500.nuv'
	    self.tv_channel = 13

    def loadTestConfigFile(self, filename):
        """Load the test script's config data from a file."""
        config = ConfigParser.ConfigParser()
        if os.path.exists(filename):
            config.read(filename)
            try:
                host = config.get("GMyth Test Scripts Config", "Host")
                port = config.get("GMyth Test Scripts Config", "Port")
                db_user = config.get("GMyth Test Scripts Config", "User")
                db_passwd = config.get("GMyth Test Scripts Config", "Password")
                db_name = config.get("GMyth Test Scripts Config", "Database")
                filename = config.get("GMyth Test Scripts Config", "Filename")
                tv_channel = config.get("GMyth Test Scripts Config", "Channel")
            except:
                raise "ConfigError", "Problems on configuration file (%s)!!!" % filename
            else:
                self.host = host
                self.port = port
                self.db_user = db_user
                self.db_passwd = db_passwd
                self.db_name = db_name
                self.filename = filename
                self.tv_channel = tv_channel
        else:
            print "Creating file %s..." % filename 
            self.create()

    def get_host(self):
        return self.host

    def get_port(self):
        return self.port

    def get_filename(self):
        return self.filename

    def get_db_user(self):
        return self.db_user

    def get_db_passwd(self):
        return self.db_passwd

    def get_db_name(self):
        return self.db_name

    def get_tv_channel(self):
        return self.tv_channel

def wait_string(file, string):
    while True:
        line = file.readline().strip()
        if line == string:
            return

sync_string = '===SYNC==='
