/**
 * GMyth Library
 *
 * @file gmyth/gmyth_util.h
 * 
 * @brief <p> This component provides utility functions 
 * 	(dealing with dates, time, string formatting, etc.).
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Luiz de Morais Melo <hallyson.melo@indt.org.br>
 * @author Rosfran Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GMYTH_UTIL_H_
#define GMYTH_UTIL_H_

#include <time.h>
#include <glib.h>

#include "gmyth_stringlist.h"
#include "gmyth_backendinfo.h"
#include "gmyth_programinfo.h"

G_BEGIN_DECLS 

typedef struct {
    guint64 total_space;
    guint64 used_space;
} GMythBackendDetails;


GString*        gmyth_util_time_to_isoformat                (time_t time_value);
GString*        gmyth_util_time_to_string                   (time_t time_value);
time_t          gmyth_util_string_to_time                   (GString *time_str);
gchar*          gmyth_util_time_to_isoformat_from_time_val_fmt
                                                            (const gchar *fmt_string,
                                                             const GTimeVal *time_val);
GTimeVal*       gmyth_util_string_to_time_val_fmt           (const gchar *fmt_string,
                                                             const gchar *time_str);
GTimeVal*       gmyth_util_string_to_time_val               (const gchar *time_str);
gchar*          gmyth_util_time_to_isoformat_from_time_val  (const GTimeVal *time);
gchar*          gmyth_util_time_to_mythformat_from_time_val (const GTimeVal *time);
gchar*          gmyth_util_time_to_string_only_date         (const GTimeVal *time);
gchar*          gmyth_util_time_to_string_only_time         (const GTimeVal *time);
gchar*          gmyth_util_time_to_string_from_time_val     (const GTimeVal *time_val);
struct tm*      gmyth_util_time_val_to_date                 (const GTimeVal * time);

gboolean        gmyth_util_get_backend_details (GMythSocket *sock, GMythBackendDetails **details);
void            gmyth_util_backend_details_free (GMythBackendDetails *details);

gboolean        gmyth_util_file_exists                      (GMythBackendInfo *backend_info,
                                                             const gchar * filename);
gboolean        gmyth_util_file_exists_from_socket          (GMythSocket *sock, 
                                                             const gchar *filename);
gboolean        gmyth_util_file_exists_and_get_remote_dir   (GMythBackendInfo *backend_info,
                                                             const gchar *filename,
                                                             gchar **current_dir);
gchar*          gmyth_util_create_filename                  (const gint chan_id,
                                                             const GTimeVal * start_time);
GList*          gmyth_util_get_channel_list                 (GMythBackendInfo *backend_info);
GSList*         gmyth_util_get_all_recordings               (GMythBackendInfo *backend_info);
GMythProgramInfo*
                gmyth_util_get_recording_from_channel       (GMythBackendInfo *backend_info,
                                                             const gchar *channel);

G_END_DECLS
#endif                          /* GMYTH_UTIL_H_ */
