/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _CharBoxPrivate CharBoxPrivate;

#define TYPE_TABLE_BOX (table_box_get_type ())
#define TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TABLE_BOX, TableBox))
#define TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TABLE_BOX, TableBoxClass))
#define IS_TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TABLE_BOX))
#define IS_TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TABLE_BOX))
#define TABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TABLE_BOX, TableBoxClass))

typedef struct _TableBox TableBox;
typedef struct _TableBoxClass TableBoxClass;
typedef struct _TableBoxPrivate TableBoxPrivate;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _CharBox {
	GtkEventBox parent_instance;
	CharBoxPrivate * priv;
};

struct _CharBoxClass {
	GtkEventBoxClass parent_class;
};

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _TableBox {
	CharBox parent_instance;
	TableBoxPrivate * priv;
};

struct _TableBoxClass {
	CharBoxClass parent_class;
};

struct _TableBoxPrivate {
	Canvas* _canvas;
	gchar _character;
	gboolean did_enter;
	gboolean drag_status;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;



GType char_box_get_type (void);
GType table_box_get_type (void);
GType canvas_get_type (void);
#define TABLE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TABLE_BOX, TableBoxPrivate))
enum  {
	TABLE_BOX_DUMMY_PROPERTY,
	TABLE_BOX_CANVAS,
	TABLE_BOX_CHARACTER
};
static void table_box_set_character (TableBox* self, gchar value);
static void table_box_set_canvas (TableBox* self, Canvas* value);
TableBox* table_box_new (gchar c, Canvas* can);
TableBox* table_box_construct (GType object_type, gchar c, Canvas* can);
TableBox* table_box_new (gchar c, Canvas* can);
Canvas* table_box_get_canvas (TableBox* self);
void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all);
static gboolean table_box_handle_drag_motion (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, guint time_);
static void table_box_handle_drag_leave (TableBox* self, TableBox* box, GdkDragContext* context, guint time_);
static gboolean table_box_handle_drag_drop (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, guint time_);
GType mult_puzzle_get_type (void);
MultPuzzle* canvas_get_puzzle (Canvas* self);
GType mult_puzzle_char_get_type (void);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
gchar table_box_get_character (TableBox* self);
GType mult_puzzle_guess_status_get_type (void);
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
static void table_box_handle_data_received (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time_);
void char_box_set_letter (CharBox* self, const char* value);
void char_box_set_border (CharBox* self, GtkShadowType value);
static void _table_box_handle_data_received_gtk_widget_drag_data_received (TableBox* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static gboolean _table_box_handle_drag_motion_gtk_widget_drag_motion (TableBox* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self);
static void _table_box_handle_drag_leave_gtk_widget_drag_leave (TableBox* _sender, GdkDragContext* context, guint time_, gpointer self);
static gboolean _table_box_handle_drag_drop_gtk_widget_drag_drop (TableBox* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self);
static GObject * table_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer table_box_parent_class = NULL;
static void table_box_finalize (GObject* obj);
static void table_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void table_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



TableBox* table_box_construct (GType object_type, gchar c, Canvas* can) {
	GParameter * __params;
	GParameter * __params_it;
	TableBox * self;
	g_return_val_if_fail (can != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "character";
	g_value_init (&__params_it->value, G_TYPE_CHAR);
	g_value_set_char (&__params_it->value, c);
	__params_it++;
	__params_it->name = "canvas";
	g_value_init (&__params_it->value, TYPE_CANVAS);
	g_value_set_object (&__params_it->value, can);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


TableBox* table_box_new (gchar c, Canvas* can) {
	return table_box_construct (TYPE_TABLE_BOX, c, can);
}


static gboolean table_box_handle_drag_motion (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, guint time_) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (!self->priv->did_enter) {
		canvas_highlight_box (self->priv->_canvas, (CharBox*) box, FALSE, TRUE, TRUE);
		self->priv->did_enter = TRUE;
	}
	self->priv->drag_status = FALSE;
	gtk_drag_get_data ((GtkWidget*) self, context, gdk_atom_intern_static_string ("STRING"), (guint32) time_);
	if (!self->priv->drag_status) {
		canvas_highlight_box (self->priv->_canvas, (CharBox*) box, FALSE, TRUE, TRUE);
	}
	return self->priv->drag_status;
}


static void table_box_handle_drag_leave (TableBox* self, TableBox* box, GdkDragContext* context, guint time_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	canvas_highlight_box (self->priv->_canvas, (CharBox*) box, FALSE, FALSE, TRUE);
	self->priv->did_enter = FALSE;
}


static gboolean table_box_handle_drag_drop (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, guint time_) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	self->priv->drag_status = TRUE;
	gtk_drag_get_data ((GtkWidget*) self, context, gdk_atom_intern_static_string ("STRING"), (guint32) time_);
	if (!self->priv->drag_status) {
		canvas_highlight_box (self->priv->_canvas, (CharBox*) box, FALSE, TRUE, TRUE);
	}
	return TRUE;
}


static void table_box_handle_data_received (TableBox* self, TableBox* box, GdkDragContext* context, gint x, gint y, GtkSelectionData* data, guint info, guint time_) {
	gint digit;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	if (data->length <= 0) {
		return;
	}
	digit = data->data[0] - 48;
	if (!self->priv->drag_status) {
		gboolean* _tmp1_;
		gint guesses_size;
		gint guesses_length1;
		gint _tmp0_;
		gboolean* guesses;
		_tmp1_ = NULL;
		guesses = (_tmp1_ = mult_puzzle_get_letter_guesses (canvas_get_puzzle (self->priv->_canvas), (MultPuzzleChar) self->priv->_character, &_tmp0_), guesses_length1 = _tmp0_, guesses_size = guesses_length1, _tmp1_);
		if (!guesses[digit]) {
			self->priv->drag_status = TRUE;
			gdk_drag_status (context, GDK_ACTION_COPY, (guint32) time_);
		}
		guesses = (g_free (guesses), NULL);
	} else {
		MultPuzzleGuessStatus rv;
		rv = mult_puzzle_guess (canvas_get_puzzle (self->priv->_canvas), digit, (MultPuzzleChar) self->priv->_character);
		gtk_drag_finish (context, rv == MULT_PUZZLE_GUESS_STATUS_CORRECT, FALSE, (guint32) time_);
	}
}


Canvas* table_box_get_canvas (TableBox* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_canvas;
}


static void table_box_set_canvas (TableBox* self, Canvas* value) {
	Canvas* _tmp2_;
	Canvas* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_canvas = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)), (self->priv->_canvas == NULL) ? NULL : (self->priv->_canvas = (g_object_unref (self->priv->_canvas), NULL)), _tmp2_);
	g_object_notify ((GObject *) self, "canvas");
}


gchar table_box_get_character (TableBox* self) {
	g_return_val_if_fail (self != NULL, '\0');
	return self->priv->_character;
}


static void table_box_set_character (TableBox* self, gchar value) {
	g_return_if_fail (self != NULL);
	self->priv->_character = value;
	g_object_notify ((GObject *) self, "character");
}


static void _table_box_handle_data_received_gtk_widget_drag_data_received (TableBox* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	table_box_handle_data_received (self, _sender, context, x, y, selection_data, info, time_);
}


static gboolean _table_box_handle_drag_motion_gtk_widget_drag_motion (TableBox* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self) {
	return table_box_handle_drag_motion (self, _sender, context, x, y, time_);
}


static void _table_box_handle_drag_leave_gtk_widget_drag_leave (TableBox* _sender, GdkDragContext* context, guint time_, gpointer self) {
	table_box_handle_drag_leave (self, _sender, context, time_);
}


static gboolean _table_box_handle_drag_drop_gtk_widget_drag_drop (TableBox* _sender, GdkDragContext* context, gint x, gint y, guint time_, gpointer self) {
	return table_box_handle_drag_drop (self, _sender, context, x, y, time_);
}


static GObject * table_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TableBoxClass * klass;
	GObjectClass * parent_class;
	TableBox * self;
	klass = TABLE_BOX_CLASS (g_type_class_peek (TYPE_TABLE_BOX));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TABLE_BOX (obj);
	{
		char* _tmp0_;
		GtkTargetEntry* _tmp1_;
		gint entries_size;
		gint entries_length1;
		GtkTargetEntry* entries;
		self->priv->did_enter = FALSE;
		self->priv->drag_status = TRUE;
		_tmp0_ = NULL;
		char_box_set_letter ((CharBox*) self, _tmp0_ = g_strdup_printf ("%c", (gint) self->priv->_character));
		_tmp0_ = (g_free (_tmp0_), NULL);
		char_box_set_border ((CharBox*) self, GTK_SHADOW_IN);
		_tmp1_ = NULL;
		entries = (_tmp1_ = g_new0 (GtkTargetEntry, 1), entries_length1 = 1, entries_size = entries_length1, _tmp1_);
		entries[0].target = "STRING";
		entries[0].flags = (guint) GTK_TARGET_SAME_APP;
		entries[0].info = (guint) 0;
		gtk_drag_dest_set ((GtkWidget*) self, 0, entries, entries_length1, GDK_ACTION_MOVE);
		g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _table_box_handle_data_received_gtk_widget_drag_data_received, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-motion", (GCallback) _table_box_handle_drag_motion_gtk_widget_drag_motion, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-leave", (GCallback) _table_box_handle_drag_leave_gtk_widget_drag_leave, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) _table_box_handle_drag_drop_gtk_widget_drag_drop, self, 0);
		/* Translators: The next several characters are used to show the 'unknown'
		 digits in the puzzle.  Translate to something that makes sense for
		 your alphabet.*/
		N_ ("A");
		N_ ("B");
		N_ ("C");
		N_ ("D");
		N_ ("E");
		N_ ("F");
		N_ ("G");
		N_ ("H");
		N_ ("I");
		N_ ("J");
		entries = (g_free (entries), NULL);
	}
	return obj;
}


static void table_box_class_init (TableBoxClass * klass) {
	table_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TableBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = table_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = table_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = table_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = table_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TABLE_BOX_CANVAS, g_param_spec_object ("canvas", "canvas", "canvas", TYPE_CANVAS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TABLE_BOX_CHARACTER, g_param_spec_char ("character", "character", "character", G_MININT8, G_MAXINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void table_box_instance_init (TableBox * self) {
	self->priv = TABLE_BOX_GET_PRIVATE (self);
}


static void table_box_finalize (GObject* obj) {
	TableBox * self;
	self = TABLE_BOX (obj);
	(self->priv->_canvas == NULL) ? NULL : (self->priv->_canvas = (g_object_unref (self->priv->_canvas), NULL));
	G_OBJECT_CLASS (table_box_parent_class)->finalize (obj);
}


GType table_box_get_type (void) {
	static GType table_box_type_id = 0;
	if (table_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TableBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) table_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TableBox), 0, (GInstanceInitFunc) table_box_instance_init, NULL };
		table_box_type_id = g_type_register_static (TYPE_CHAR_BOX, "TableBox", &g_define_type_info, 0);
	}
	return table_box_type_id;
}


static void table_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TableBox * self;
	gpointer boxed;
	self = TABLE_BOX (object);
	switch (property_id) {
		case TABLE_BOX_CANVAS:
		g_value_set_object (value, table_box_get_canvas (self));
		break;
		case TABLE_BOX_CHARACTER:
		g_value_set_char (value, table_box_get_character (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void table_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TableBox * self;
	self = TABLE_BOX (object);
	switch (property_id) {
		case TABLE_BOX_CANVAS:
		table_box_set_canvas (self, g_value_get_object (value));
		break;
		case TABLE_BOX_CHARACTER:
		table_box_set_character (self, g_value_get_char (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




