/*
 * Copyright 2009 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gmetrics.result

import org.gmetrics.test.AbstractTestCase
import org.gmetrics.metric.Metric

/**
 * Tests for NumberMetricResult
 *
 * @author Chris Mair
 * @version $Revision: 130 $ - $Date: 2010-07-21 22:46:24 -0400 (Wed, 21 Jul 2010) $
 */
class NumberMetricResultTest extends AbstractTestCase {
    private static final DEFAULT_FUNCTIONS = ['total', 'average', 'minimum', 'maximum']
    private static final METRIC = [getName:{'TestMetric'}, getFunctions:{ DEFAULT_FUNCTIONS }] as Metric

    void testPassingNullMetricIntoConstructorThrowsException() {
        shouldFailWithMessageContaining('metric') { new NumberMetricResult(null, 1) }
    }

    void testPassingNullValueIntoConstructorThrowsException() {
        shouldFailWithMessageContaining('number') { new NumberMetricResult(METRIC, null) }
    }

    void testGetMetricIsSameMetricValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23)
        assert result.getMetric() == METRIC
    }

    void testGetLineNumberIsSameValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23, 67)
        assert result.getLineNumber() == 67
    }

    void testGetTotalValueIsSameIntegerValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23)
        assert result['total'] == 23
    }

    void testGetTotalValueIsSameBigDecimalValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 0.23456)
        assert result['total'] == 0.23456
    }

    void testGetAverageValueIsSameIntegerValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23)
        assert result['average'] == 23
    }

    void testGetMinimumValueIsSameIntegerValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23)
        assert result['minimum'] == 23
    }

    void testGetMaximumValueIsSameIntegerValuePassedIntoConstructor() {
        def result = new NumberMetricResult(METRIC, 23)
        assert result['maximum'] == 23
    }

    void testGetCountIsOneForSingleValue() {
        def result = new NumberMetricResult(METRIC, 0.23456)
        assert result.getCount() == 1
    }

    void testGetValueForUnknownFunctionIsNull() {
        def result = new NumberMetricResult(METRIC, 0.23456)
        assert result['xxx'] == null
    }

    void testUsesFunctionNamesFromMetric() {
        final FUNCTION_NAMES = ['average', 'maximum']
        def metric = [getName:{'TestMetric'}, getFunctions:{ FUNCTION_NAMES }] as Metric
        def result = new NumberMetricResult(metric, 1)
        assert result['average'] != null
        assert result['maximum'] != null
        assert result['total'] == null
        assert result['minimum'] == null
    }

}