/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */

/******************************************************************************
globus_mp_mpl.c

Description:

  MPL activation

CVS Information:

  $Source: /home/globdev/CVS/globus-packages/mp/source/globus_mp_mpl.c,v $
  $Date: 2005/04/18 21:41:55 $
  $Revision: 1.6 $
  $State: Exp $
  $Author: smartin $
******************************************************************************/

/******************************************************************************
			     Include header files
******************************************************************************/
#include "globus_mp_mpl.h"
#ifdef GLOBUS_MP_HAS_MPL_PROTO

#include "version.h"

/******************************************************************************
			 Global variable declarations
******************************************************************************/
globus_mp_communicator_t		globus_i_mp_mpl_comm_next = 42;


/******************************************************************************
			  Module activation structure
******************************************************************************/
static int
globus_l_mp_mpl_activate(void);

static int
globus_l_mp_mpl_deactivate(void);

static void
globus_l_mp_mpl_atexit(void);


globus_module_descriptor_t		globus_i_mp_mpl_module =
{
    "globus_mp_mpl",
    globus_l_mp_mpl_activate,
    globus_l_mp_mpl_deactivate,
    globus_l_mp_mpl_atexit,
    GLOBUS_NULL,
    &local_version
};


/******************************************************************************
			   MPL activation functions
******************************************************************************/
static int
globus_l_mp_mpl_activate(void)
{
}


static int
globus_l_mp_mpl_deactivate(void)
{
    return GLOBUS_TRUE;
}


static void
globus_l_mp_mpl_atexit(void)
{
}

#endif
