/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-gtk-tag.h"

#include "ginspector-tag.h"


void
g_inspector_tag_to_widget (GtkWidget *widget)
{
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));


  g_inspector_tag_to_object (G_OBJECT (widget));
}

gboolean
g_inspector_tag_check_widget (GtkWidget *widget)
{
  gboolean tagged;

  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);


  tagged = g_inspector_tag_check_object (G_OBJECT (gtk_widget_get_toplevel (widget)));

  return tagged;
}

static void
g_inspector_menu_map (GtkWidget *widget,
		      gpointer   user_data)
{
  GtkMenu *menu;

  menu = GTK_MENU (widget);

  g_inspector_tag_to_widget (gtk_widget_get_toplevel (GTK_WIDGET (menu)));
}

void
g_inspector_tag_to_menu (GtkMenu *menu)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (GTK_IS_MENU (menu));


  if (g_inspector_tag_check_widget (GTK_WIDGET (menu)) == FALSE)
    {
      g_inspector_tag_to_widget (GTK_WIDGET (menu));
      g_inspector_tag_to_widget (GTK_WIDGET (menu->toplevel));

      g_signal_connect (menu,
			"map",
			G_CALLBACK (g_inspector_menu_map),
			NULL);
    }
}
