import sys
import os
import gobject
import gtk
import gtk.glade


class GladeWindow(gtk.Window):
    
    def __init__(self, path, root, domain=None):
        """Base class for Windows whose controls are loaded from Glade definitions.
           Does most of the work of loading the Glade file and reparenting the
           widgets."""    
           
        gtk.Window.__init__(self)
        self.hide()
        
        if os.path.isfile(path):
            self.glade_path = path
        else:
            glade_dir = os.path.dirname(sys.argv[0])
            self.glade_path = os.path.join(glade_dir, path)
        
        self.glade = self.create_glade(self.glade_path, root, domain)
        self.glade_widget = self.glade.get_widget(root)
        print root
        
        child = self.glade_widget.get_child()
        child.reparent(self)
        
        self.set_title(self.glade_widget.title)
        self.set_border_width(self.glade_widget.border_width)
        
        for widget in self.glade.get_widget_prefix(''):
            name = gtk.glade.get_widget_name(widget)
            if name.strip() != '':
                setattr(self, name, widget)
        
    def create_glade(self, path, root, domain):
        return gtk.glade.XML(path, root, domain)
    
gobject.type_register(GladeWindow)
