/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define DEBUGWHILE

using System;
using System.IO;
using System.Xml;
using System.Text;
using System.Web;
using System.Collections.Generic;

using Galaxium.Core;

namespace Galaxium.Protocol
{
	public static class TextUtility
	{
		public const string ISO8601Format = "yyyy-MM-ddTHH:mm:ss.fffffffzzz";

		public static string GetParameter (byte[] data, int index)
		{
			return GetParameters (data, index)[0];
		}

		public static string[] GetParameterRange (byte[] data, int start, int count)
		{
			int[] indices = new int[count];
			int index = 0;
			for (int i = start; i < count; i++)
				indices[index++] = i;
			return GetParameters (data, indices);
		}

		public static string[] GetParameters (byte[] data, params int[] indices)
		{
			char[] chars = Encoding.UTF8.GetChars (data);
			string[] parameters = new string[indices.Length];

			int len = chars.Length;
			int paramIndex = 0;
			int prevParamCharIndex = 0;
			int returnIndex = 0;

			int index = 0;
			
#if DEBUGWHILE
			int iterations = 0;
#endif
			
			do {
#if DEBUGWHILE
				iterations++;
				
				if (iterations > 100)
					Anculus.Core.Log.Warn ("Iteration {0}", iterations);
#endif
				
				char c = chars[index];
				if (c == ' ' || c == '\r') { //TODO: allow a list of chars to be passed
					if (IsRequestedIndex (indices, paramIndex)) {
						string param = null;
						if (index == prevParamCharIndex) {
							param = String.Empty;
						} else {
							int strlen = index - prevParamCharIndex;
							char[] str = new char[strlen];
							Array.Copy (chars, prevParamCharIndex, str, 0, strlen);
							param = new string (str);
						}
						parameters[returnIndex++] = param;
					}

					prevParamCharIndex = (index + 1);
					paramIndex++;
				}

				index++;
			} while (index < len && returnIndex < indices.Length);

			//make sure the last parameter is also added
			if (IsRequestedIndex (indices, paramIndex)) {
				string param = null;
				if (index == prevParamCharIndex) {
					param = String.Empty;
				} else {
					int strlen = index - prevParamCharIndex;
					char[] str = new char[strlen];
					Array.Copy (chars, prevParamCharIndex, str, 0, strlen);
					param = new string (str);
				}
				parameters[returnIndex++] = param;
			}

			return parameters;
		}

		private static bool IsRequestedIndex (int[] indices, int index)
		{
			foreach (int i in indices)
				if (i == index)
					return true;
			return false;
		}
	}
}