/*
 * Galaxium Messenger
 * Copyright (C) 2008 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Xml;
using System.Collections.Generic;

using Galaxium.Core;

namespace Galaxium.Protocol
{
	public sealed class ConversationLogEntry
	{
		private IConversationLog _log;
		private int _archiveIndex;
		private int _streamIndex;
		
		private DateTime _timestamp;
		private string _uid;
		private string _displayName;
		private string _message;
		
		private bool _isEvent;
		
		internal ConversationLogEntry (IConversationLog log, int archiveIndex, int streamIndex, DateTime timestamp, string uid, string displayName, string message)
		{
			this._log = log;
			this._archiveIndex = archiveIndex;
			this._streamIndex = streamIndex;
			this._timestamp = timestamp;
			this._uid = uid;
			this._displayName = displayName;
			this._message = message;
			
			_isEvent = false;
		}

		internal ConversationLogEntry (IConversationLog log, int archiveIndex, int streamIndex, DateTime timestamp, string message)
		{
			this._log = log;
			this._archiveIndex = archiveIndex;
			this._streamIndex = streamIndex;
			this._timestamp = timestamp;
			this._message = message;
			
			_isEvent = true;
		}
		
		public IConversationLog Log
		{
			get { return _log; }
		}

		public int ArchiveIndex
		{
			get { return _archiveIndex; }
		}
		
		public int StreamIndex
		{
			get { return _streamIndex; }
		}

		public DateTime TimeStamp
		{
			get { return _timestamp; }
		}

		public string UniqueIdentifier
		{
			get { return _uid; }
		}

		public string DisplayName
		{
			get { return _displayName; }
		}

		public string Message
		{
			get { return _message; }
		}
		
		public bool IsEvent
		{
			get { return _isEvent; }
		}
	}
}