/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;

using Gtk;
using Gdk;
using Pango;

using Galaxium.Core;
using Galaxium.Gui;
using Galaxium.Gui.GtkGui;

namespace Galaxium.Protocol.Msn.GtkGui
{
	public sealed class BasicContactTreeView : GtkTreeView<HintTreeNodeRenderer>
	{
		internal BasicContactTreeView () : base ()
		{
			AddNodeBuilder (new BasicContactTreeNodeBuilder ());
			
			this.RulesHint = false;
			this.Reorderable = false;
			this.ShowExpanders = false;
			
			Sorter = new BasicContactTreeSorter ();
		}
		
		/*private void RulesHintDataFunc (CellLayout layout, CellRenderer cell, TreeModel model, TreeIter iter)
		{
			TreeNodeRenderer.RenderBackground (cell);
		}*/

		protected override void ApplyLayout (TreeViewColumn col, CellRendererText textRenderer, CellRendererPixbuf pixbufRenderer)
		{
			textRenderer.Ellipsize = EllipsizeMode.End;
			textRenderer.Xalign = 0.0f;
			textRenderer.Xpad = 0;
			
			col.Expand = true;
			col.MinWidth = 25;
		}

		protected override ITreeNodeRenderer GetTreeNodeRenderer ()
		{
			return new HintTreeNodeRenderer (this);
		}
	}
}