/*
 * Galaxium Messenger
 * Copyright (C) 2005-2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text.RegularExpressions;
using System.Collections.Generic;

using Gtk;
using Pango;

using Galaxium.Core;
using Galaxium.Gui;
using Galaxium.Protocol;

using Anculus.Core;

namespace Galaxium.Gui.GtkGui
{
	public class MessageDisplayWidget : ScrolledWindow
	{
		IConfigurationSection _config;
		IMessageDisplay _display;
		
		public MessageDisplayWidget (IConversation conversation) : base ()
		{
			_config = Configuration.MessageDisplay.Section;
			
			MessageDisplayExtension ext = AddinUtility.GetExtensionNode<MessageDisplayExtension> (
				"/Galaxium/Gui/Widgets/MessageDisplay",
				_config.GetString (Configuration.MessageDisplay.Active.Name, Configuration.MessageDisplay.Active.Default), true);
			
			this.ShadowType = ShadowType.EtchedIn;
			this.HscrollbarPolicy = PolicyType.Never;
			this.VscrollbarPolicy = PolicyType.Always;
			
			try
			{
				_display = ext.CreateInstance (conversation);
				
				//never add with a viewport -> messes up the scrolling
				//FIXME: why is that? because i really really hate the Gtk warnings that are generated by this code
				this.Add ((Widget)_display.Widget);
			}
			catch
			{
				foreach (MessageDisplayExtension ex in AddinUtility.GetExtensionNodes ("/Galaxium/Gui/Widgets/MessageDisplay"))
				{
					try
					{
						_display = ex.CreateInstance (conversation);
						this.Add ((Widget)_display.Widget);
					}
					catch (Exception e)
					{
						Log.Error (e, "Unable to create {0} message display", ex.Name);
						_display = null;
					}
				}
				
				if (_display == null)
					this.Add (new Label ("Unable to create message display"));
			}
			
			this.DeleteEvent += delegate { this.Remove (this.Child); };
		}
		
		public void AddMessage (ITextMessage message)
		{
			if (_display != null)
				_display.AddMessage (message);
		}
		
		public void AddHistoryMessage (ITextMessage message)
		{
			if (_display != null)
				_display.AddHistoryMessage (message);
		}
		
		public void AddOfflineMessage (ITextMessage message)
		{
			if (_display != null)
				_display.AddOfflineMessage (message);
		}
		
		public void AddImageMessage (IEntity source, byte[] data)
		{
			if (_display != null)
				_display.AddImageMessage (source, data);
		}
		
		public void AddSystemMessage (string message)
		{
			if (_display != null)
				_display.AddSystemMessage (message);
		}
		
		public void UpdateEmoticon (IEmoticon emoticon)
		{
			if (_display != null)
				_display.UpdateEmoticon (emoticon);
		}
	}
}