/*
 * Galaxium Messenger
 * Copyright (C) 2005-2007  Ben Motmans  <ben.motmans@gmail.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

using System;
using System.Collections.Generic;

using Gtk;

using Galaxium.Core;

namespace Galaxium.Gui.GtkGui
{
	public sealed class ObjectTreeNodeBuilder : ITreeNodeBuilder<DefaultTreeNodeRenderer>
	{
		private string _contextMenuExtensionPoint;

		/// <summary>
		/// 
		/// </summary>
		/// <param name="contextMenuExtensionPoint">Null if no context menu should be shown.</param>
		public ObjectTreeNodeBuilder (string contextMenuExtensionPoint)
		{
			this._contextMenuExtensionPoint = contextMenuExtensionPoint;
		}

		public ObjectTreeNodeBuilder ()
		{
		}

		public Type NodeType
		{
			get { return typeof (object); }
		}

		public string ContextMenuExtensionPoint
		{
			get { return _contextMenuExtensionPoint; }
		}

		public void RenderIcon (TreeNodeContext context, DefaultTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
		}

		public void RenderText (TreeNodeContext context, DefaultTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget dtnw = widget as DefaultTreeNodeWidget;
			if (dtnw != null) {
				CellRendererText cell = dtnw.GetTextRenderer ();
				if (cell != null)
					renderer.RenderText (cell, context.NodeObject.ToString ());
			}
		}

		public bool HasDynamicChildNodes (TreeNodeContext context)
		{
			return false;
		}

		public void BuildDynamicChildNodes (TreeNodeContext context)
		{
		}

		public void NodeActivated (TreeNodeContext context)
		{
		}

		public string GetComparableContent (TreeNodeContext context)
		{
			return context.NodeObject.ToString ();
		}
	}
}