/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * Copyright (C) 2007 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;

using Gtk;
using Gdk;

using Galaxium.Core;

namespace Galaxium.Gui.GtkGui
{
	public sealed class HintTreeNodeRenderer : ITreeNodeRenderer
	{
		//TODO: StyleGetProperty->  odd-row-color, even-row-color
		//wait for bug http://bugzilla.ximian.com/show_bug.cgi?id=81253 to be resolved
		
		private Color _normalColor;
		private Color _darkColor;

		private Style _style;

		private bool _useRulesHint;

		public HintTreeNodeRenderer (TreeView widget)
		{
			_useRulesHint = widget.RulesHint;
			_style = Rc.GetStyle (widget);
			widget.StateChanged += new StateChangedHandler (widget_StateChanged);
			
			// FIXME: This looks too aweful right now until we fix.
			//_darkColor = _style.Mid (widget.State);
			_darkColor = _style.BaseColors[(int)widget.State];
			_normalColor = _style.BaseColors[(int)widget.State];
		}

		private void widget_StateChanged (object sender, StateChangedArgs args)
		{
			StateType state = (sender as Widget).State;
			
			// FIXME: This looks too aweful right now until we fix.
			//_darkColor = _style.Mid (state);
			_darkColor = _style.BaseColors[(int)state];
			_normalColor = _style.BaseColors[(int)state];
		}

		public void RenderBackground (CellRenderer cell)
		{
			SetCellBackground (cell, cell.IsExpander);
		}

		public void RenderIcon (CellRendererPixbuf cell, Pixbuf pixbuf, bool darken)
		{
			if (pixbuf == null)
			{
				cell.Visible = false;
				cell.Pixbuf = null;
			}
			else
			{
				cell.Visible = true;
				cell.Pixbuf = pixbuf;
				cell.Width = pixbuf.Width;
				cell.Height = pixbuf.Height;
				SetCellBackground (cell, darken);
			}
		}

		public void RenderText (CellRendererText cell, string text, bool darken)
		{
			cell.Markup = text;
			cell.Xalign = 0.0f;
			cell.Xpad = 2;
			
			SetCellBackground (cell, darken);
		}

		private void SetCellBackground (CellRenderer cell, bool darken)
		{
			if (darken)
				cell.CellBackgroundGdk = _darkColor;
			else
				cell.CellBackgroundGdk = _normalColor;
		}
	}
}