/*
 * Galaxium Messenger
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Runtime.InteropServices;

namespace Galaxium.GStreamer
{
	internal delegate void GStreamerEosCallback (IntPtr player);
	internal delegate void GStreamerErrorCallback (IntPtr player, uint domain, int code, IntPtr error, IntPtr debug);
	
	internal static class GStreamerInterop
	{
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_init ();
		
		[DllImport ("libgalaxium")]
		internal static extern IntPtr libgalaxium_gstreamer_open (IntPtr filename);
		
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_close (HandleRef player);
		
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_play (HandleRef player);
		
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_stop (HandleRef player);
		
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_set_eos_callback (HandleRef player, GStreamerEosCallback cb);
		
		[DllImport ("libgalaxium")]
		internal static extern void libgalaxium_gstreamer_set_error_callback (HandleRef player, GStreamerErrorCallback cb);
	}
}
