/*
 * Galaxium Messenger
 * Copyright (C) 2008 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Mono.Unix;
using Anculus.Core;

namespace Galaxium.Core
{
	public class GettextTranslationBackend : ITranslationBackend
	{
		public bool Initialize ()
		{
			Catalog.Init (CoreUtility.TranslationDomain, CoreUtility.LocaleDirectory);
			return true;
		}
		
		public string GetString (string key)
		{
			return Catalog.GetString (key);
		}

		public string GetString (string key, params object[] args)
		{
			return String.Format (Catalog.GetString (key), args);
		}

		public string GetPluralString (string key, string plural, int count)
		{
			return Catalog.GetPluralString (key, plural, count);
		}

		public string GetPluralString (string key, string plural, int count, params object[] args)
		{
			return String.Format (Catalog.GetPluralString (key, plural, count), args);
		}
	}
}