/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.IO;
using System.Collections.Generic;

using NDesk.DBus;
using org.freedesktop.DBus;

using Anculus.Core;
using Galaxium.Core;

namespace Galaxium.Client
{
	public sealed class BansheeSongInformationBackend : AbstractSongInformationBackend
	{
		const string bus = "org.gnome.Banshee";
		const string objectPath = "/org/gnome/Banshee/Player";
		
		private IPlayer player;
		
		public override string Name
		{
			get { return "Banshee"; }
		}

		public override bool IsAvailable ()
		{
			if (!Bus.Session.NameHasOwner(bus))
				return false;

			player = Bus.Session.GetObject<IPlayer>(bus, new ObjectPath (objectPath));
			return true;
		}

		public override SongInformation GetCurrentSong ()
		{
			int status = player.GetPlayingStatus ();
			if (status >= 0) {
				//1=play,0=pause
				SongInformation info = new SongInformation (
					player.GetPlayingArtist (), player.GetPlayingTitle (),
					player.GetPlayingAlbum (), player.GetPlayingGenre (),
					player.GetPlayingDuration ()
				);
				return info;
			}
			return null;
		}

		public override void Initialize ()
		{
			BusG.Init();
		}

		public override void Unload ()
		{
		}
		
		[Interface("org.gnome.Banshee.Core")]
		interface IPlayer
		{
			string GetPlayingArtist();
			string GetPlayingAlbum();
			string GetPlayingTitle();
			string GetPlayingGenre();
			string GetPlayingUri();
			string GetPlayingCoverUri();
			int GetPlayingDuration();
			int GetPlayingPosition();
			int GetPlayingStatus();
		}
	}
}