/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"
#include "commented.h"
#include "functions.h"



void populate_server_settings(struct w *widgets)
{
    /* Populates the server tab */
    FILE *fp;
    int i = 0, x = 0, have_sysinit_script = 0;
    int share_internet = 0;
    int have_firestarter_line = 0;
    long val = 0, file_size = 0;
    char *line, *tmp;
    gchar *info, *utf8 = NULL;
    gchar *openvpn_server_conf;
    gchar *openvpn_sysinit_script;
    gchar *openvpn_openssl_conf;

    /* Clear all non certificate entries. */
    for(i=0; i<8; i++)
      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[i]), "");

    /* Set default values for combos 0 to 7. */
    for(i=0; i<8; i++)
    {
	/* Some combos should be set to "Yes" or the second choise. */
	if( i == 0 || i == 2 || i == 4 || i == 6 || i == 7 )
	  gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[i]), 1);
	else
	  gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[i]), 0);
    }

    /* Insert values from gadmin-openvpn-server.conf */
    openvpn_server_conf = g_strdup_printf("%s/server/gadmin-openvpn-server.conf", OPENVPN_SYSCONF_DIR);
    if((fp=fopen(openvpn_server_conf, "r"))==NULL)
    {
	info = g_strdup_printf("%s %s", _("Error: Can not open file:\n"), openvpn_server_conf);
        show_info(info);
        g_free(info);
        g_free(openvpn_server_conf);
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line==NULL || strlen(line) < 4 || commented(line) )
          continue;

	/* External interface name is read from the sysinit script (Entry 0) */

	/* External interface address */
	if( cmplowercase(line, "local ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}

	/* Server port */
	if( cmplowercase(line, "port ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), i);
	    }
	}

	/* LAN interface address */
	if( cmplowercase(line, "server-bridge ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]==' ' && tmp[i-1]!=' ' )
	        break;
	    tmp[i]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}

	/* LAN subnet mask */
	if( cmplowercase(line, "server-bridge ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]==' ' && tmp[i-1]!=' ' )
	        break;
	    tmp[i]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}

	/* LAN broadcast address is populated from the script */

	/* Client address range */
	if( cmplowercase(line, "server-bridge ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[6]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}

        /* Combo: Protocol */
	if( cmplowercase(line, "proto ") )
	{
	    if( cmplowercase(line, "tcp") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
	    }
	    else
	    if( cmplowercase(line, "udp") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
	    }
	    else
	    {
		printf("Populate_server_settings.c: I have no choise for this proto\n");
	    }
	}

	/* Combo: TAP device name */
	if( cmplowercase(line, "dev ") )
	{
	    if( cmplowercase(line, "tap0") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
	    }
	    else
	    if( cmplowercase(line, "tap1") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
	    }
	    else
	    if( cmplowercase(line, "tap2") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 2);
	    }
	    else
	    if( cmplowercase(line, "tap3") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 3);
	    }
	    else
	    {
		printf("Populate_server_settings.c: I have no choise for this dev\n");
	    }
	}

	/* Combo: Require authentication */
	if( cmplowercase(line, "plugin ")
	&&  cmplowercase(line, "auth-pam.so")
	&&  cmplowercase(line, "login") )
	{
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
	}

	/* Combo: Encryption type */
	if( cmplowercase(line, "cipher ") )
	{
	    if( cmplowercase(line, "bf-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
	    }
	    else
	    if( cmplowercase(line, "aes-128-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
	    }
	    else
	    if( cmplowercase(line, "aes-256-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 2);
	    }
	    else
	    if( cmplowercase(line, "des-ede3-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 3);
	    }
	    else
	    {
		printf("Populate_server_settings.c: I have no choise for this cipher\n");
	    }
	}

	/* Combo: Client-to-client */
	if( cmplowercase(line, "client-to-client") )
	{
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 1);
	}

	/* Tunnel all traffic */
	if( cmplowercase(line, "push \"redirect-gateway\"") )
	{
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 1);
	}

	/* Use compression */
	if( cmplowercase(line, "comp-lzo") )
	{
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 1);
	}

	/* Share internet and Using Firestarter is populated from the script */


	/* Max connections */
	if( cmplowercase(line, "max-clients ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), i);
	    }
	}

	/* Spin: Loglevel / verbosity */
	if( cmplowercase(line, "verb ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[2]), i);
	    }
	}

	/* Spin: Ping interval (the first digits) */
	if( cmplowercase(line, "keepalive ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    for(i=strlen(tmp)-1; tmp[i]!='\0'; i--)
	      if( tmp[i]==' ' && tmp[i-1]!=' ' )
	        break;
	    tmp[i]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[3]), i);
	    }
	}

	/* Spin: Ping timeout (the second digits) */
	if( cmplowercase(line, "keepalive ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[4]), i);
	    }
	}

	/* Server user */
	if( cmplowercase(line, "user ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[7]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}

	/* Server group */
	if( cmplowercase(line, "group ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[8]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
    }
    fclose(fp);
    free(line);
    free(tmp);
    g_free(openvpn_server_conf);


    /* Insert values from the sysinit script if it exists */
    openvpn_sysinit_script = g_strdup_printf("%s/gadmin-openvpn-server", SYSINIT_SCRIPTS_DIR);
    if((fp=fopen(openvpn_sysinit_script, "r"))==NULL)
    {
	/* Dont show a popup and dont return */
    }
    else
    {
	have_sysinit_script = 1;

	fseek(fp, 0, SEEK_END);
	file_size = ftell(fp);
	rewind(fp);

	line = allocate(file_size);
	tmp  = allocate(1024);

	if( file_size > 1 )
	while(fgets(line, file_size, fp)!=NULL)
	{
	    if( line==NULL || strlen(line) < 4 || commented(line) )
              continue;

	    /* External interface name */
	    if( cmplowercase(line, "external_iface_name=\"") )
	    {
		for(i=0; line[i]!='\0'; i++)
	          if( line[i]=='"')
	            break;

		snprintf(tmp, 1000, "%s", &line[i+1]);
		if( tmp[strlen(tmp)-1]=='\n')
	          tmp[strlen(tmp)-1]='\0';

		for(i=0; tmp[i]!='\0'; i++)
	          if( tmp[i]=='"' )
	    	    break;
		tmp[i]='\0';

		utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }

	    /* External interface address is populated from the conf above (Entry 1) */

	    /* LAN interface name */
	    if( cmplowercase(line, "lan_iface_name=\"") )
	    {
		for(i=0; line[i]!='\0'; i++)
	          if( line[i]=='"')
	            break;

		snprintf(tmp, 1000, "%s", &line[i+1]);
		if( tmp[strlen(tmp)-1]=='\n')
	          tmp[strlen(tmp)-1]='\0';

		for(i=0; tmp[i]!='\0'; i++)
	          if( tmp[i]=='"' )
	    	    break;
		tmp[i]='\0';

		utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }

	    /* LAN interface address is populated from the conf */

	    /* LAN interface netmask is populated from the conf */

	    /* LAN broadcast address */
	    if( cmplowercase(line, "lan_iface_broadcast=\"") )
	    {
		for(i=0; line[i]!='\0'; i++)
	          if( line[i]=='"')
	    	    break;

		snprintf(tmp, 1000, "%s", &line[i+1]);
		if( tmp[strlen(tmp)-1]=='\n')
	          tmp[strlen(tmp)-1]='\0';

		for(i=0; tmp[i]!='\0'; i++)
	          if( tmp[i]=='"' )
	    	    break;
		tmp[i]='\0';

		utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }

	    /* Share internet. */
	    if( cmplowercase(line, "iptables -t nat -a postrouting -s") )
	    {
		share_internet = 1;
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 1);
	    }
	    /* Using Firestarter */
	    if( cmplowercase(line, "firestarter -s") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 1);
		have_firestarter_line = 1;
	    }
	}
	fclose(fp);
	free(line);
	free(tmp);
    }
    g_free(openvpn_sysinit_script);

    /* We want sharing to be default*/
    if( ! share_internet )
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 0);

    if( ! have_firestarter_line )
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 0);


    /* Set standard options if theres no sysinit script */
    if( ! have_sysinit_script )
    {
	tmp = allocate(1024);

	snprintf(tmp, 1000, "%s", "eth0");
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
	if( utf8!=NULL )
          g_free(utf8);

	snprintf(tmp, 1000, "%s", "eth1");
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
	if( utf8!=NULL )
          g_free(utf8);

	snprintf(tmp, 1000, "%s", "10.8.0.255");
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
	if( utf8!=NULL )
          g_free(utf8);

	free(tmp);
    }


    /* Insert values from the openssl conf if it exists */
    openvpn_openssl_conf = g_strdup_printf("%s/server/certs/gadmin-openvpn-openssl.conf", OPENVPN_SYSCONF_DIR);
    if((fp=fopen(openvpn_openssl_conf, "r"))==NULL)
    {
	/* Dont show a popup */
        g_free(openvpn_openssl_conf);
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line==NULL || strlen(line) < 4 || commented(line) )
          continue;

	/* Server address */
	if( strstr(line, "commonName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
		if( x >= 2 && line[x-2]=='=' )
		{
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[9]), utf8);
		    break;
		}
	    }
	}
	/* Email address */
	if( strstr(line, "emailAddress = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
	        {
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[10]), utf8);
		    break;
		}
	    }
	}
	/* State or province */
	if( strstr(line, "stateOrProvinceName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
		{
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);
		    break;
	        }
	    }
	}
	/* City or town */
	if( strstr(line, "localityName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
		{
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);
		    break;
		}
	    }
	}
	/* Organization */
	if( strstr(line, "organizationName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
	        {
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[13]), utf8);
		    break;
		}
	    }
	}
	/* Organizational unit */
	if( strstr(line, "organizationalUnitName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
	        {
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[14]), utf8);
		    break;
		}
	    }
	}
	/* Default certificate bits */
	if( strstr(line, "default_bits = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
		if( x >= 2 && line[x-2]=='=' )
		{
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    if( chars_are_digits(tmp) )
		    {
        		val = atoi(tmp);
        		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[5]), val);
			break;
		    }
		}
	    }
        }
	/* Default days valid */
    	if( strstr(line, "default_days = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
	        if( x >= 2 && line[x-2]=='=' )
	        {
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    if( chars_are_digits(tmp) )
		    {
			val = atoi(tmp);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[6]), val);
			break;
		    }
		}
	    }
        }

	/* Password entry is located at 14 */

	/* Country code */
	if( strstr(line, "countryName = ") )
	{
	    for(x=0; line[x]!='\0'; x++)
	    {
		if( x >= 2 && line[x-2]=='=' )
		{
		    snprintf(tmp, line[x]+x, line+x);
		    tmp[strlen(tmp)-1]='\0';
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[16]), utf8);
		    break;
		}
	    }
	}
    }
    fclose(fp);
    free(tmp);
    free(line);

    g_free(openvpn_openssl_conf);
}
