//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1998
// 
// uSystemTask.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jun 22 15:25:53 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 11:20:19 2005
// Update Count     : 100
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uSystemTask.h>

#include <cstdio>					// fprintf

//#include <uDebug.h>


volatile bool uSystemTask::pthreadDetach = false;


void uSystemTask::pthreadCheck() {
    if ( pthreadDetachCnt != 0 ) {
	detached.wait();
    } // if
} // uSystemTask::pthreadCheck


void uSystemTask::pthreadDetachStart() {
    pthreadDetach = true;
    // Do the increment here because of potential recursive entry from "reaper"
    // creating another pthread.
    pthreadDetachCnt += 1;
} // uSystemTask::pthreadDetachStart


void uSystemTask::pthreadDetachEnd( uBaseTask &victim ) {
    uSystemTask::victim = &victim;
    pthreadDetachCnt -= 1;
} // uSystemTask::pthreadDetachEnd


void uSystemTask::main() {
    for ( ;; ) {
	_Accept( ~uSystemTask ) {
	    break;
	} else _Accept( reaper ) {
	    delete victim;
	} else _Accept( pthreadCheck ) {
	} else _Accept( pthreadDetachStart ) {
	} else _Accept( pthreadDetachEnd ) {
	    delete victim;
	    if ( pthreadDetachCnt == 0 ) {
		detached.signalBlock();
	    } // if
	} else uTimeout( uDuration( 1 ) ) {		// 1 second
	} // _Accept

#if __U_LOCALDEBUGGER_H__
	// check for debugger attach request

	if ( uKernelModule::uAttaching != 0 ) {
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSystemTask &)0x%p.main, attaching\n", this );
#endif // __U_DEBUG_H__ 
	    int port = uKernelModule::uAttaching;
	    uKernelModule::uAttaching = 0;		// reset flag so don't do this again
	    uLocalDebugger::uLocalDebuggerInstance = new uLocalDebugger( port );
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSystemTask &)0x%p.main, local debugger started\n", this );
#endif // __U_DEBUG_H__
	} // if

#if 0 // moved to uProcessor kernel because of problems, but may ultimately need to be here for KDB
#ifndef __U_MULTI__
	if ( uKernelModule::uDeadlock ) {
	    fprintf( stderr, "Clusters and tasks present at deadlock:\n" );
	    uSeqIter<uClusterDL> ci;
	    uClusterDL *cr;
	    for ( ci.over( *uKernelModule::uGlobalClusters ); ci >> cr; ) {
		uCluster *cluster = &cr->uGet();
		fprintf( stderr, "%.256s (0x%p)\n", cluster->getName(), cluster );

		fprintf( stderr, "\ttasks:\n" );
		uBaseTaskDL *bt;
		for ( uSeqIter<uBaseTaskDL> iter( cluster->getTasksOnCluster() ); iter >> bt; ) {
		    uBaseTask *task = &bt->uGet();
		    fprintf( stderr, "\t\t %.256s (0x%p)\n", task->getName(), task );
		} // for
	    } // for
	    uAbort( "No ready or pending tasks.\n"
		    "Possible cause is tasks in a synchronization or mutual exclusion deadlock.", this );
	} // if
#endif // ! __U_MULTI__
#endif

#endif // __U_LOCALDEBUGGER_H__
    } // for
} // uSystemTask::main


uSystemTask::uSystemTask() : uBaseTask( *uKernelModule::uSystemCluster ) {
    pthreadDetachCnt = 0;
} // uSystemTask::uSystemTask


uSystemTask::~uSystemTask() {
} // uSystemTask::~uSystemTask


void uSystemTask::reaper( uBaseTask &victim ) {
    uSystemTask::victim = &victim;
} // uSystemTask::reaper


// Local Variables: //
// compile-command: "gmake install" //
// End: //
