/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _IMAGE_WRAP_P_H_
#define _IMAGE_WRAP_P_H_

namespace GTLCore {
  class AbstractImage;
}

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createImageType !                          //
//---------------------- WARNING ----------------------//
struct ImageWrap {
  GTLCore::AbstractImage* image;
  void* memToVec;
  void* vecToMem;
  enum ImageIndexes {
    INDEX_IMAGE = 0,
    INDEX_MEM_TO_VEC = 1,
    INDEX_VEC_TO_MEM = 2
  };
};

extern "C" {
  char* image_wrap_data( ImageWrap* _imageWrap, int _x, int _y );

}

#endif
