<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session())
	{
		// this page has been added exclusively for the Search page, at this
		// point, but will be enhanced for generic use later on.
		
		$page_title1 = replace_lang_var('site', $CONFIG_VARS['site.title'], $lang_var['site_help']);
		$page_title2 = NULL;
		$help_lang_var = NULL;
		switch($HTTP_VARS['page'])
		{
			case 'search.php':
				$page_title2 = $LANG_VARS['item_search'];
				$help_lang_var = $LANG_VARS['search_help'];
				break;
		}

		if($page_title2!==NULL)
			echo _theme_header($page_title1." > ".$page_title2, FALSE);
		else
			echo _theme_header($page_title1, FALSE);
		echo("<h2>".$page_title1."</h2>");
		if($page_title2!==NULL)
			echo("<h3>".$page_title2."</h3>");
		if($help_lang_var!==NULL)
		{
			echo('<table border=0 width=100% cellpadding=0 cellspacing=0><tr><td>'
				.format_help_block($help_lang_var)
				.'</td></tr></table>');
		}
		else
		{
			echo _theme_error($LANG_VARS['no_help_available']);
		}
		echo _theme_footer();
	}
	else//not a valid session.
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>